/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.chest;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import me.duquee.createutilities.CreateUtilities;
import me.duquee.createutilities.blocks.voidtypes.VoidLinkBehaviour;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestBlock;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestContainer;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestInventoriesData;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestInventory;
import me.duquee.createutilities.voidlink.VoidLinkSlot;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoidChestTileEntity
extends SmartBlockEntity
implements MenuProvider {
    VoidLinkBehaviour link;
    VoidChestInventory inventory;
    private int openCount;
    public LerpedFloat lid = LerpedFloat.linear().startWithValue(0.0);

    public VoidChestTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void createLink() {
        Triple<VoidLinkSlot, VoidLinkSlot, VoidLinkSlot> slots = VoidLinkSlot.makeSlots(index -> new VoidLinkSlot((int)index, state -> (Direction)state.m_61143_((Property)VoidChestBlock.f_54117_), VecHelper.voxelSpace((double)5.5, (double)7.5, (double)0.999f)));
        this.link = new VoidLinkBehaviour(this, slots);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    private boolean hasPersistentStorageData() {
        return this.f_58857_ != null && !this.f_58857_.f_46443_;
    }

    private static VoidChestInventoriesData getPersistentStorageData() {
        return CreateUtilities.VOID_CHEST_INVENTORIES_DATA;
    }

    public VoidChestInventory getItemStorage() {
        return this.hasPersistentStorageData() ? VoidChestTileEntity.getPersistentStorageData().computeStorageIfAbsent(this.link.getNetworkKey()) : this.inventory;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(this::getItemStorage).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        if (clientPacket) {
            this.inventory = new VoidChestInventory(this.link.getNetworkKey());
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
            this.openCount = tag.m_128451_("OpenCount");
        }
        super.read(tag, clientPacket);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        if (this.hasPersistentStorageData()) {
            tag.m_128365_("Inventory", (Tag)this.getItemStorage().serializeNBT());
        } else if (this.inventory != null) {
            tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
        if (clientPacket) {
            tag.m_128405_("OpenCount", this.openCount);
        }
        super.write(tag, clientPacket);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.createutilities.void_chest");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return VoidChestContainer.create(id, inventory, this);
    }

    public void tick() {
        this.lid.chase(this.openCount > 0 ? 1.0 : 0.0, (double)0.1f, LerpedFloat.Chaser.LINEAR);
        this.lid.tickChaser();
    }

    public boolean isClosed() {
        return this.lid.settled() && this.lid.getChaseTarget() == 0.0f;
    }

    public void startOpen(Player player) {
        if (this.openCount < 0) {
            this.openCount = 0;
        }
        ++this.openCount;
        this.sendData();
        if (this.openCount == 1) {
            this.f_58857_.m_142346_((Entity)player, GameEvent.f_157803_, this.f_58858_);
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    public void stopOpen(Player player) {
        --this.openCount;
        this.sendData();
        if (this.openCount <= 0) {
            this.f_58857_.m_142346_((Entity)player, GameEvent.f_157802_, this.f_58858_);
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }
}

