/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.WeakHashMap;
import net.mehvahdjukaar.smarterfarmers.SFHarvestFarmland;
import net.mehvahdjukaar.smarterfarmers.SmarterFarmers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;

public class FarmTaskDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    public static FarmTaskDebugRenderer INSTANCE = new FarmTaskDebugRenderer();
    private final WeakHashMap<Villager, SFHarvestFarmland> villagerFarmTasks = new WeakHashMap();

    public void m_5630_() {
        this.villagerFarmTasks.clear();
    }

    public void m_7790_(PoseStack poseStack, MultiBufferSource bufferSource, double camX, double camY, double camZ) {
        if (!SmarterFarmers.DEBUG_RENDERERS.get().booleanValue()) {
            return;
        }
        this.villagerFarmTasks.entrySet().forEach(entry -> {
            if (this.isPlayerCloseEnoughToMob((Villager)entry.getKey())) {
                this.renderInfo(poseStack, bufferSource, (SFHarvestFarmland)((Object)((Object)entry.getValue())), (Villager)entry.getKey());
            }
        });
    }

    private Minecraft mc() {
        return Minecraft.m_91087_();
    }

    private void renderInfo(PoseStack poseStack, MultiBufferSource multiBufferSource, SFHarvestFarmland task, Villager villager) {
        int i = 0;
        FarmTaskDebugRenderer.renderTextOverMob(poseStack, multiBufferSource, (Position)villager.m_20182_(), i++, "Activities: " + String.valueOf(villager.m_6274_().m_147340_()), 0xFF9900, 0.03f);
        FarmTaskDebugRenderer.renderTextOverMob(poseStack, multiBufferSource, (Position)villager.m_20182_(), i++, "Active " + task.active, task.active ? 39168 : 0x990000, 0.03f);
        FarmTaskDebugRenderer.renderTextOverMob(poseStack, multiBufferSource, (Position)villager.m_20182_(), i++, "Last attempted start: " + task.lastTriedToStart, -1, 0.03f);
        FarmTaskDebugRenderer.renderTextOverMob(poseStack, multiBufferSource, (Position)villager.m_20182_(), i++, "Wants to plant: " + String.valueOf(task.seedToHold), 65314, 0.03f);
        FarmTaskDebugRenderer.renderTextOverMob(poseStack, multiBufferSource, (Position)villager.m_20182_(), i++, "Plant Timer: " + task.plantTimer, -1, 0.03f);
        for (int j = 0; j < villager.m_35311_().m_6643_(); ++j) {
            ItemStack ii = villager.m_35311_().m_8020_(j);
            if (ii.m_41619_()) continue;
            FarmTaskDebugRenderer.renderTextOverMob(poseStack, multiBufferSource, (Position)villager.m_20182_(), i++, ii.toString(), 0x99AA00, 0.03f);
        }
        FarmTaskDebugRenderer.renderTextOverMob(poseStack, multiBufferSource, (Position)villager.m_20182_(), i++, "Inventory:", 0xAABB00, 0.03f);
        if (task.aboveFarmlandPos != null) {
            FarmTaskDebugRenderer.highlightPos(poseStack, multiBufferSource, task.aboveFarmlandPos, 1.0f, 1.0f, 1.0f, -0.2f);
        }
        if (task.farmlandAround == null) {
            return;
        }
        for (Pair<BlockPos, SFHarvestFarmland.Action> v : List.copyOf(task.farmlandAround)) {
            BlockPos p = ((BlockPos)v.getFirst()).m_7495_();
            switch ((SFHarvestFarmland.Action)((Object)v.getSecond())) {
                case HARVEST: {
                    FarmTaskDebugRenderer.highlightPos(poseStack, multiBufferSource, p, 0.4f, 1.0f, 0.2f, 0.03f);
                    break;
                }
                case HARVEST_AND_REPLANT: {
                    FarmTaskDebugRenderer.highlightPos(poseStack, multiBufferSource, p, 1.0f, 1.0f, 0.2f, 0.05f);
                    break;
                }
                case PLANT: {
                    FarmTaskDebugRenderer.highlightPos(poseStack, multiBufferSource, p, 1.0f, 0.4f, 0.2f, 0.05f);
                }
            }
        }
    }

    private static void highlightPos(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockPos blockPos, float r, float g, float b, float scale) {
        DebugRenderer.m_269371_((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (BlockPos)blockPos, (float)scale, (float)r, (float)g, (float)b, (float)0.6f);
    }

    private static void renderTextOverMob(PoseStack poseStack, MultiBufferSource multiBufferSource, Position position, int i, String string, int color, float scale) {
        double x = position.m_7096_();
        double y = position.m_7098_() + 2.4 + (double)i * 0.25;
        double z = position.m_7094_();
        DebugRenderer.m_269439_((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (String)string, (double)x, (double)y, (double)z, (int)color, (float)scale, (boolean)false, (float)0.5f, (boolean)true);
    }

    private boolean isPlayerCloseEnoughToMob(Villager villager) {
        LocalPlayer player = this.mc().f_91074_;
        return villager.m_19950_((Entity)player, 30.0);
    }

    public void trackTask(Villager entity, SFHarvestFarmland sfHarvestFarmland) {
        if (SmarterFarmers.DEBUG_RENDERERS.get().booleanValue()) {
            this.villagerFarmTasks.put(entity, sfHarvestFarmland);
        }
    }
}

