/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class EatFoodGoal
extends Behavior<Villager> {
    private int eatingTime;
    private int cooldown = 0;
    private int buffer = 40;

    public EatFoodGoal(int minDur, int maxDur) {
        super(Map.of(MemoryModuleType.f_26374_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_26382_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_26381_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_26323_, MemoryStatus.VALUE_ABSENT), minDur, maxDur);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (pOwner.f_19797_ - pOwner.m_21213_() < 400) {
            return false;
        }
        if (pOwner.m_6274_().m_21954_(Activity.f_37984_)) {
            return false;
        }
        if (pOwner.m_21223_() < pOwner.m_21233_() && pOwner.m_35311_().m_18949_(Villager.f_35369_.keySet())) {
            --this.buffer;
            return this.buffer <= 0;
        }
        return false;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6735_(pLevel, (LivingEntity)pEntity, pGameTime);
        this.buffer = 40;
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        pEntity.m_21573_().m_26573_();
        this.eatingTime = 80;
        SimpleContainer inventory = pEntity.m_35311_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            Integer food = (Integer)Villager.f_35369_.get(itemstack.m_41720_());
            if (food == null) continue;
            ItemStack s = itemstack.m_41777_();
            s.m_41764_(1);
            if (itemstack.m_41613_() == 0) {
                inventory.m_6836_(i, ItemStack.f_41583_);
            }
            pEntity.m_21008_(InteractionHand.MAIN_HAND, s);
        }
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        if (pEntity.m_6274_().m_21954_(Activity.f_37984_)) {
            return false;
        }
        if (pEntity.f_19797_ - pEntity.m_21213_() < 200) {
            return false;
        }
        return this.eatingTime > 0 && Villager.f_35369_.get(pEntity.m_21205_().m_41720_()) != null;
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.eatingTime-- < 50) {
            ItemStack stack = pOwner.m_21205_();
            if (stack.m_41619_()) {
                return;
            }
            if (this.eatingTime % 2 == 0) {
                pLevel.m_7605_((Entity)pOwner, (byte)45);
            }
            if (this.eatingTime % 5 == 0) {
                pOwner.m_5496_(pOwner.m_7866_(stack), 0.3f + 0.4f * (float)pLevel.f_46441_.m_188503_(2), (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.2f + 1.3f);
            }
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        Integer food;
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        ItemStack stack = pEntity.m_21205_();
        Item item = stack.m_41720_();
        pEntity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        if (item != Items.f_41852_ && this.eatingTime <= 0 && (food = (Integer)Villager.f_35369_.get(item)) != null) {
            for (int i = 0; i < pEntity.m_35311_().m_6643_(); ++i) {
                ItemStack s = pEntity.m_35311_().m_8020_(i);
                if (s.m_41720_() != item) continue;
                s.m_41620_(1);
                pEntity.m_5634_((float)Math.max(1, food));
                item.m_5922_(stack, (Level)pLevel, (LivingEntity)pEntity);
                this.cooldown = 20 * (4 + pLevel.f_46441_.m_188503_(14)) + pLevel.f_46441_.m_188503_(20);
                return;
            }
        }
    }
}

