/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.rpcsdk.connection;

import com.hypherionmc.simplerpc.rpcsdk.DiscordRpc;
import com.hypherionmc.simplerpc.rpcsdk.connection.BaseConnection;
import com.hypherionmc.simplerpc.rpcsdk.connection.WinRegistry;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.NoDiscordClientException;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.PipeAccessDenied;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class WindowsConnection
extends BaseConnection {
    private RandomAccessFile pipe = null;
    private boolean opened = false;

    WindowsConnection(DiscordRpc rpc) {
        super(rpc);
    }

    @Override
    boolean isOpen() {
        return this.opened;
    }

    @Override
    boolean open() throws NoDiscordClientException, PipeAccessDenied {
        String pipeName = "\\\\?\\pipe\\discord-ipc-%s";
        if (this.isOpen()) {
            throw new IllegalStateException("Connection is already opened");
        }
        for (int i = 0; i < 10; ++i) {
            try {
                File test = new File(String.format(pipeName, i));
                if (!test.exists()) continue;
                this.pipe = new RandomAccessFile(String.format(pipeName, i), "rw");
                this.opened = true;
                this.getRpc().printDebug("Connected to IPC Pipe %s", String.format(pipeName, i));
                return true;
            }
            catch (FileNotFoundException e) {
                if (e.getMessage().toLowerCase().contains("access is denied")) {
                    throw new PipeAccessDenied("Cannot access pipe " + String.format(pipeName, i) + " due to permission errors. Ensure discord is NOT running in administrator mode!");
                }
                e.printStackTrace();
                this.getRpc().printDebug("Failed to connect to pipe %s", e);
                continue;
            }
            catch (SecurityException sec) {
                this.getRpc().getLogger().error("Failed to open RPC Connection, with error Access Denied. Is Discord running in Administrator mode?");
            }
        }
        throw new NoDiscordClientException();
    }

    @Override
    void close() {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.pipe.close();
        }
        catch (Exception e) {
            this.getRpc().printDebug("Failed to close pipe %s", e);
        }
        this.opened = false;
    }

    @Override
    boolean write(byte[] bytes) {
        if (!this.isOpen()) {
            return false;
        }
        try {
            this.pipe.write(bytes);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    boolean read(byte[] bytes, int length) {
        if (bytes == null || bytes.length == 0) {
            return bytes != null;
        }
        if (!this.isOpen()) {
            return false;
        }
        try {
            long available = this.pipe.length() - this.pipe.getFilePointer();
            if (available < (long)length) {
                return false;
            }
            int read = this.pipe.read(bytes, 0, length);
            if (read != length) {
                throw new IOException("Read less data than supplied. Expected: " + length + ". Got: " + read);
            }
            return true;
        }
        catch (IOException e) {
            this.getRpc().printDebug("Failed to read packet %s", e);
            this.close();
            return false;
        }
    }

    @Override
    public void register(String applicationId, String command) {
        String javaExePath;
        String javaLibraryPath = System.getProperty("java.home");
        File javaExeFile = new File(javaLibraryPath.split(";")[0] + "/bin/java.exe");
        File javawExeFile = new File(javaLibraryPath.split(";")[0] + "/bin/javaw.exe");
        String string = javaExeFile.exists() ? javaExeFile.getAbsolutePath() : (javaExePath = javawExeFile.exists() ? javawExeFile.getAbsolutePath() : null);
        if (javaExePath == null) {
            throw new RuntimeException("Unable to find java path");
        }
        String openCommand = command != null ? command : javaExePath;
        String protocolName = "discord-" + applicationId;
        String protocolDescription = "URL:Run game " + applicationId + " protocol";
        String keyName = "Software\\Classes\\" + protocolName;
        String iconKeyName = keyName + "\\DefaultIcon";
        String commandKeyName = keyName + "\\DefaultIcon";
        try {
            WinRegistry.createKey(keyName);
            WinRegistry.writeStringValue(keyName, "", protocolDescription);
            WinRegistry.writeStringValue(keyName, "URL Protocol", "\u0000");
            WinRegistry.createKey(iconKeyName);
            WinRegistry.writeStringValue(iconKeyName, "", javaExePath);
            WinRegistry.createKey(commandKeyName);
            WinRegistry.writeStringValue(commandKeyName, "", openCommand);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to modify Discord registry keys", ex);
        }
    }

    @Override
    public void registerSteamGame(String applicationId, String steamId) {
        try {
            String steamPath = WinRegistry.readString();
            if (steamPath == null) {
                throw new RuntimeException("Steam exe path not found");
            }
            steamPath = steamPath.replaceAll("/", "\\");
            String command = "\"" + steamPath + "\" steam://rungameid/" + steamId;
            this.register(applicationId, command);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to register Steam game", ex);
        }
    }
}

