/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.time.JulianDate;
import com.hypherionmc.simplerpc.jodd.time.TimeUtil;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;

public class SqlTimestampConverter
implements TypeConverter<Timestamp> {
    @Override
    public Timestamp convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return new Timestamp(calendar.getTimeInMillis());
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new Timestamp(date.getTime());
        }
        if (value instanceof JulianDate) {
            return new Timestamp(((JulianDate)value).toMilliseconds());
        }
        if (value instanceof LocalDateTime) {
            return new Timestamp(TimeUtil.toMilliseconds((LocalDateTime)value));
        }
        if (value instanceof LocalDate) {
            return new Timestamp(TimeUtil.toMilliseconds((LocalDate)value));
        }
        if (value instanceof Number) {
            return new Timestamp(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException iaex) {
                throw new TypeConversionException(value, (Throwable)iaex);
            }
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new Timestamp(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

