/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.io;

import com.hypherionmc.simplerpc.jodd.io.FileNameUtil;
import com.hypherionmc.simplerpc.jodd.io.FileUtil;
import com.hypherionmc.simplerpc.jodd.io.IOUtil;
import com.hypherionmc.simplerpc.jodd.io.ZipBuilder;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import com.hypherionmc.simplerpc.jodd.util.Wildcard;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static final String ZIP_EXT = ".zip";
    public static final String GZIP_EXT = ".gz";
    public static final String ZLIB_EXT = ".zlib";

    public static File zlib(String file) throws IOException {
        return ZipUtil.zlib(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zlib(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("Can't zlib folder");
        }
        FileInputStream fis = new FileInputStream(file);
        Deflater deflater = new Deflater(9);
        String zlibFileName = file.getAbsolutePath() + ZLIB_EXT;
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)new FileOutputStream(zlibFileName), deflater);
        try {
            IOUtil.copy((InputStream)fis, dos);
        }
        finally {
            IOUtil.close(dos);
            IOUtil.close(fis);
        }
        return new File(zlibFileName);
    }

    public static File gzip(String fileName) throws IOException {
        return ZipUtil.gzip(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File gzip(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("Can't gzip folder");
        }
        FileInputStream fis = new FileInputStream(file);
        String gzipName = file.getAbsolutePath() + GZIP_EXT;
        GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(gzipName));
        try {
            IOUtil.copy((InputStream)fis, gzos);
        }
        finally {
            IOUtil.close(gzos);
            IOUtil.close(fis);
        }
        return new File(gzipName);
    }

    public static File ungzip(String file) throws IOException {
        return ZipUtil.ungzip(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File ungzip(File file) throws IOException {
        String outFileName = FileNameUtil.removeExtension(file.getAbsolutePath());
        File out = new File(outFileName);
        out.createNewFile();
        FileOutputStream fos = new FileOutputStream(out);
        GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(file));
        try {
            IOUtil.copy((InputStream)gzis, fos);
        }
        finally {
            IOUtil.close(fos);
            IOUtil.close(gzis);
        }
        return out;
    }

    public static File zip(String file) throws IOException {
        return ZipUtil.zip(new File(file));
    }

    public static File zip(File file) throws IOException {
        String zipFile = file.getAbsolutePath() + ZIP_EXT;
        return ZipBuilder.createZipFile(zipFile).add(file).recursive().save().toZipFile();
    }

    public static List<String> listZip(File zipFile) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            String entryName = entry.getName();
            entries.add(entryName);
        }
        return Collections.unmodifiableList(entries);
    }

    public static void unzip(String zipFile, String destDir, String ... patterns) throws IOException {
        ZipUtil.unzip(new File(zipFile), new File(destDir), patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destDir, String ... patterns) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        while (zipEntries.hasMoreElements()) {
            File rootDir;
            ZipEntry entry = zipEntries.nextElement();
            String entryName = entry.getName();
            if (patterns != null && patterns.length > 0 && Wildcard.matchPathOne(entryName, patterns) == -1) continue;
            File file = destDir != null ? new File(destDir, entryName) : new File(entryName);
            File file2 = rootDir = destDir != null ? destDir : new File(".");
            if (!FileUtil.isAncestor(rootDir, file, true)) {
                throw new IOException("Unzipping");
            }
            if (entry.isDirectory()) {
                if (file.mkdirs() || file.isDirectory()) continue;
                throw new IOException("Failed to create directory: " + file);
            }
            File parent = file.getParentFile();
            if (!(parent == null || parent.exists() || parent.mkdirs() || file.isDirectory())) {
                throw new IOException("Failed to create directory: " + parent);
            }
            InputStream in = zip.getInputStream(entry);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                IOUtil.copy(in, out);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close(out);
            IOUtil.close(in);
        }
        ZipUtil.close(zip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToZip(ZipOutputStream zos, File file, String path, String comment, boolean recursive) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (path == null) {
            path = file.getName();
        }
        while (path.length() != 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        boolean isDir = file.isDirectory();
        if (isDir && !StringUtil.endsWithChar(path, '/')) {
            path = path + '/';
        }
        ZipEntry zipEntry = new ZipEntry(path);
        zipEntry.setTime(file.lastModified());
        if (comment != null) {
            zipEntry.setComment(comment);
        }
        if (isDir) {
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        }
        zos.putNextEntry(zipEntry);
        if (!isDir) {
            FileInputStream is = new FileInputStream(file);
            try {
                IOUtil.copy((InputStream)is, zos);
            }
            finally {
                IOUtil.close(is);
            }
        }
        zos.closeEntry();
        if (recursive && file.isDirectory()) {
            boolean noRelativePath = StringUtil.isEmpty(path);
            File[] children = file.listFiles();
            if (children != null && children.length != 0) {
                for (File child : children) {
                    String childRelativePath = (noRelativePath ? "" : path) + child.getName();
                    ZipUtil.addToZip(zos, child, childRelativePath, comment, recursive);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToZip(ZipOutputStream zos, byte[] content, String path, String comment) throws IOException {
        while (path.length() != 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (StringUtil.endsWithChar(path, '/')) {
            path = path.substring(0, path.length() - 1);
        }
        ZipEntry zipEntry = new ZipEntry(path);
        zipEntry.setTime(System.currentTimeMillis());
        if (comment != null) {
            zipEntry.setComment(comment);
        }
        zos.putNextEntry(zipEntry);
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        try {
            IOUtil.copy((InputStream)is, zos);
        }
        finally {
            IOUtil.close(is);
        }
        zos.closeEntry();
    }

    public static void addFolderToZip(ZipOutputStream zos, String path, String comment) throws IOException {
        while (path.length() != 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (!StringUtil.endsWithChar(path, '/')) {
            path = path + '/';
        }
        ZipEntry zipEntry = new ZipEntry(path);
        zipEntry.setTime(System.currentTimeMillis());
        if (comment != null) {
            zipEntry.setComment(comment);
        }
        zipEntry.setSize(0L);
        zipEntry.setCrc(0L);
        zos.putNextEntry(zipEntry);
        zos.closeEntry();
    }

    public static void close(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

