/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.autumnity.client.model.SnailModel;
import com.teamabnormals.autumnity.common.entity.animal.Snail;
import com.teamabnormals.autumnity.core.other.AutumnityModelLayers;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnailRenderer
extends MobRenderer<Snail, SnailModel<Snail>> {
    private static final ResourceLocation SNAIL_TEXTURES = new ResourceLocation("autumnity", "textures/entity/snail/snail.png");
    private static final ResourceLocation SNAKE_SNAIL_TEXTURES = new ResourceLocation("autumnity", "textures/entity/snail/snake_snail.png");
    private static final ResourceLocation NAUTILUS_SNAIL_TEXTURES = new ResourceLocation("autumnity", "textures/entity/snail/nautilus_snail.png");

    public SnailRenderer(EntityRendererProvider.Context context) {
        super(context, new SnailModel(context.m_174023_(AutumnityModelLayers.SNAIL)), 0.5f);
    }

    public ResourceLocation getTextureLocation(Snail entity) {
        String s = ChatFormatting.m_126649_((String)entity.m_7755_().getString().toLowerCase());
        if (s != null) {
            if ("snake".equals(s) || "snakeblock".equals(s) || "snake block".equals(s) || "snailblock".equals(s) || "snail block".equals(s)) {
                return SNAKE_SNAIL_TEXTURES;
            }
            if ("nautilus".equals(s) || "nautilus snail".equals(s)) {
                return NAUTILUS_SNAIL_TEXTURES;
            }
        }
        return SNAIL_TEXTURES;
    }

    protected void setupRotations(Snail entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        double d0 = entityLiving.getShakeAmount(partialTicks);
        double d1 = d0 > 0.0 ? 2.0 : -2.0;
        double d2 = Math.sin(12.6 * d0) * d1 * d0;
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(6.0f * (float)d2));
    }
}

