/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.autumnity.common.entity.animal.Turkey;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TurkeyModel<T extends Turkey>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public TurkeyModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightWing = this.body.m_171324_("right_wing");
        this.leftWing = this.body.m_171324_("left_wing");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.0f, -5.0f, -2.0f, 4.0f, 6.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("waddle", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171506_(-1.0f, -1.0f, -4.0f, 2.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171506_(-2.0f, -3.0f, -4.0f, 4.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171506_(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, false), PartPose.m_171423_((float)0.0f, (float)21.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171506_(0.0f, 0.0f, -4.0f, 2.0f, 6.0f, 8.0f, true), PartPose.m_171423_((float)5.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171506_(-2.0f, 0.0f, -4.0f, 2.0f, 6.0f, 8.0f, false), PartPose.m_171423_((float)-5.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(16, 4).m_171506_(-7.0f, -10.0f, 0.0f, 14.0f, 10.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)4.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(30, 17).m_171506_(-1.5f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, false), PartPose.m_171423_((float)-3.0f, (float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(30, 17).m_171506_(-1.5f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, true), PartPose.m_171423_((float)3.0f, (float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialtick = ageInTicks - (float)((Turkey)((Object)entityIn)).f_19797_;
        float winganim = ((Turkey)((Object)entityIn)).getWingRotation(partialtick);
        float peckanim = ((Turkey)((Object)entityIn)).getPeckProgress(partialtick);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ += peckanim * 0.8f;
        this.head.f_104202_ = -3.0f - peckanim * 1.5f;
        this.rightWing.f_104205_ = -winganim;
        this.leftWing.f_104205_ = winganim;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }
}

