/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Objects;
import net.minecraft.world.level.storage.LevelSummary;
import org.jetbrains.annotations.NotNull;

public class LevelData {
    private static final Gson GSON = new GsonBuilder().create();
    public String file_name;
    public String display_name;
    public boolean requires_manual_conversion;
    public boolean locked;
    public boolean experimental;
    public String icon_path;
    public String game_type;
    public String difficulty;
    public boolean allow_commands;
    public String settings_level_name;
    public long last_played;
    public int level_data_version;
    public String minecraft_version_name;
    public boolean snapshot;
    public boolean can_edit;
    public boolean can_recreate;
    public boolean can_delete;

    @NotNull
    public static LevelData fromLevelSummary(@NotNull LevelSummary summary) {
        LevelData data = new LevelData();
        data.file_name = summary.m_78358_();
        data.display_name = summary.m_78361_();
        data.requires_manual_conversion = summary.m_193020_();
        data.locked = summary.m_78375_();
        data.experimental = summary.m_246454_();
        data.icon_path = summary.m_230875_().toAbsolutePath().toString();
        data.game_type = summary.m_78367_().m_7912_();
        data.difficulty = summary.m_164913_().m_46931_().m_7912_();
        data.allow_commands = summary.m_164913_().m_46932_();
        data.settings_level_name = summary.m_164913_().m_46917_();
        data.last_played = summary.m_78366_();
        data.level_data_version = summary.m_78371_().m_78389_();
        data.minecraft_version_name = summary.m_78371_().m_78393_();
        data.snapshot = summary.m_78371_().m_78395_();
        data.can_edit = false;
        data.can_recreate = false;
        data.can_delete = true;
        return data;
    }

    @NotNull
    public static LevelData deserialize(@NotNull String json) {
        return Objects.requireNonNullElse((LevelData)GSON.fromJson(json, LevelData.class), new LevelData());
    }

    @NotNull
    public String serialize() {
        return GSON.toJson((Object)this);
    }
}

