/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerHasTagPlaceholder
extends Placeholder {
    public PlayerHasTagPlaceholder() {
        super("player_has_tag");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        String playerName = dps.values.get("player_name");
        String tagName = dps.values.get("tag_name");
        if (level != null && playerName != null && tagName != null) {
            for (AbstractClientPlayer player : level.m_6907_()) {
                if (!player.m_7755_().getString().equals(playerName)) continue;
                return String.valueOf(player.m_19880_().contains(tagName));
            }
        }
        return "false";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("player_name", "tag_name");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.player_has_tag", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.player_has_tag.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.placeholders.categories.world", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("player_name", "Steve");
        values.put("tag_name", "my_tag");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

