/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.common.entity.vehicle;

import com.teamabnormals.boatload.common.entity.vehicle.BoatloadBoat;
import com.teamabnormals.boatload.core.registry.BoatloadEntityTypes;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class LargeBoat
extends BoatloadBoat {
    public LargeBoat(EntityType<? extends Boat> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public LargeBoat(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)BoatloadEntityTypes.LARGE_BOAT.get()), worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public LargeBoat(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType<? extends Boat>)((EntityType)BoatloadEntityTypes.LARGE_BOAT.get()), worldIn);
    }

    protected boolean m_7310_(Entity passenger) {
        if (this.m_20197_().size() >= this.m_213801_() - 1 && LargeBoat.isPassengerBig(passenger)) {
            return false;
        }
        return passenger.m_20205_() < 1.8f && super.m_7310_(passenger);
    }

    protected int m_213801_() {
        return this.getBigPassengers() == 1 ? 3 : (this.getBigPassengers() == 2 ? 2 : 4);
    }

    private static boolean isPassengerBig(Entity passenger) {
        return passenger.m_20205_() >= 1.375f;
    }

    private int getBigPassengers() {
        int i = 0;
        for (Entity passenger : this.m_20197_()) {
            if (!LargeBoat.isPassengerBig(passenger)) continue;
            ++i;
        }
        return i;
    }

    @Override
    protected void dropBreakItems() {
        super.dropBreakItems();
        super.dropBreakItems();
    }

    public void m_8119_() {
        super.m_8119_();
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.m_9236_().f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this)) continue;
                if (flag && this.m_20197_().size() < 4 && !entity.m_20159_() && entity.m_20205_() < 1.375f && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
    }

    protected void m_38396_() {
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.f_38273_) {
                this.f_38266_ -= 0.75f;
            }
            if (this.f_38274_) {
                this.f_38266_ += 0.75f;
            }
            if (this.f_38274_ != this.f_38273_ && !this.f_38275_ && !this.f_38276_) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.f_38266_);
            if (this.f_38275_) {
                f += 0.03f;
            }
            if (this.f_38276_) {
                f -= 0.005f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f)));
            this.m_38339_(this.f_38274_ && !this.f_38273_ || this.f_38275_, this.f_38273_ && !this.f_38274_ || this.f_38275_);
        }
    }

    public static boolean isAnimalEsque(Entity passenger) {
        return passenger instanceof Animal || passenger instanceof HoglinBase || LargeBoat.isPassengerBig(passenger) && passenger instanceof Spider;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction function) {
        if (this.m_20363_(passenger)) {
            float x = -0.2f;
            float z = 0.0f;
            int index = this.m_20197_().indexOf(passenger);
            int bigPassengers = this.getBigPassengers();
            boolean raft = this.getBoatloadBoatType().raft();
            boolean rotate = false;
            if (raft) {
                if (this.m_20197_().size() == 2) {
                    Entity otherPassenger = (Entity)this.m_20197_().get(1 - index);
                    if (bigPassengers == 1 || bigPassengers == 2 && (!LargeBoat.isAnimalEsque(passenger) || !LargeBoat.isAnimalEsque(otherPassenger))) {
                        rotate = LargeBoat.isAnimalEsque(passenger);
                        x = index == 0 ? (x += 0.7f) : (x -= 0.5f);
                    } else {
                        z = index == 0 ? (z += 0.6f) : (z -= 0.6f);
                    }
                } else if (this.m_20197_().size() == 3) {
                    if (bigPassengers == 1) {
                        int bigIndex = 0;
                        for (int i = 0; i < this.m_20197_().size(); ++i) {
                            if (!LargeBoat.isPassengerBig((Entity)this.m_20197_().get(i))) continue;
                            bigIndex = i;
                            break;
                        }
                        if (LargeBoat.isPassengerBig(passenger)) {
                            rotate = LargeBoat.isAnimalEsque(passenger);
                            x -= 0.5f;
                        } else {
                            x += 0.7f;
                            z = bigIndex == 0 && index == 1 || bigIndex > 0 && index == 0 ? (z += 0.6f) : (z -= 0.6f);
                        }
                    } else if (index == 0) {
                        x += 0.6f;
                        rotate = LargeBoat.isAnimalEsque(passenger);
                    } else {
                        x -= 0.5f;
                        z = index == 1 ? (z += 0.6f) : (z -= 0.6f);
                    }
                } else if (this.m_20197_().size() > 3) {
                    double mod = LargeBoat.isAnimalEsque(passenger) ? (double)0.2f : 0.0;
                    x = (float)((double)x + (double)(index < 2 ? 1 : -1) * (0.5 + mod));
                    z += (float)(index % 2 == 0 ? 1 : -1) * 0.5f;
                }
                if (LargeBoat.isAnimalEsque(passenger)) {
                    x += 0.2f;
                }
            } else {
                if (this.m_20197_().size() == 2) {
                    if (bigPassengers == 1) {
                        x = 0.5f - (float)index * 1.4f;
                        if (LargeBoat.isPassengerBig((Entity)this.m_20197_().get(0))) {
                            x -= 0.2f;
                        } else if (LargeBoat.isPassengerBig((Entity)this.m_20197_().get(1))) {
                            x += 0.2f;
                        }
                    } else {
                        x = bigPassengers == 2 ? 0.7f - (float)index * 1.8f : 0.4f - (float)index * 1.2f;
                    }
                } else if (this.m_20197_().size() == 3) {
                    i = this.m_20197_().indexOf(passenger);
                    x = 0.8f - (float)i * 1.0f;
                    if (LargeBoat.isPassengerBig((Entity)this.m_20197_().get(0))) {
                        if (i == 1) {
                            x -= 0.1f;
                        } else if (i == 2) {
                            x += 0.1f;
                        }
                    } else if (LargeBoat.isPassengerBig((Entity)this.m_20197_().get(1))) {
                        if (i == 1) {
                            x -= 0.2f;
                        } else if (i == 2) {
                            x -= 0.4f;
                        }
                        x += 0.2f;
                    } else if (LargeBoat.isPassengerBig((Entity)this.m_20197_().get(2))) {
                        if (i == 1) {
                            x += 0.1f;
                        } else if (i == 2) {
                            x -= 0.1f;
                        }
                        x += 0.2f;
                    }
                } else if (this.m_20197_().size() > 3) {
                    i = this.m_20197_().indexOf(passenger);
                    x = 1.0f - (float)i * 0.8f;
                }
                if (LargeBoat.isPassengerBig(passenger)) {
                    x += 0.1f;
                } else if (LargeBoat.isAnimalEsque(passenger)) {
                    x += 0.2f;
                }
            }
            float f1 = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            Vec3 vector3d = new Vec3((double)x, 0.0, (double)z).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            function.m_20372_(passenger, this.m_20185_() + vector3d.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vector3d.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.f_38266_);
            passenger.m_5616_(passenger.m_6080_() + this.f_38266_);
            this.m_38321_(passenger);
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                if (rotate || LargeBoat.isAnimalEsque(passenger) && !LargeBoat.isPassengerBig(passenger) && this.m_20197_().size() > 1 && !raft) {
                    int j = passenger.m_19879_() % 2 == 0 ? 90 : 270;
                    passenger.m_5618_(living.f_20883_ + (float)j);
                    passenger.m_5616_(passenger.m_6080_() + (float)j);
                }
            }
        }
    }

    @Override
    public Item m_38369_() {
        return this.getBoatloadBoatType().largeBoat().get();
    }
}

