/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.core.other;

import com.teamabnormals.savage_and_ravage.core.SavageAndRavage;
import com.teamabnormals.savage_and_ravage.core.other.tags.SRBiomeTags;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class SRBiomeModifiers {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        SRBiomeModifiers.removeSpawn(context, "witch", SRBiomeTags.HAS_ICEOLOGER, EntityType.f_20495_);
        SRBiomeModifiers.addSpawn(context, "iceologer", SRBiomeTags.HAS_ICEOLOGER, new MobSpawnSettings.SpawnerData((EntityType)SREntityTypes.ICEOLOGER.get(), 5, 1, 1));
        SRBiomeModifiers.addSpawn(context, "skeleton_villager", SRBiomeTags.HAS_COMMON_SKELETON_VILLAGER, new MobSpawnSettings.SpawnerData((EntityType)SREntityTypes.SKELETON_VILLAGER.get(), 5, 1, 1));
        SRBiomeModifiers.addSpawn(context, "skeleton_villager_snowy", SRBiomeTags.HAS_RARE_SKELETON_VILLAGER, new MobSpawnSettings.SpawnerData((EntityType)SREntityTypes.SKELETON_VILLAGER.get(), 1, 1, 1));
        SRBiomeModifiers.addSpawn(context, "skeleton_villager_weird", SRBiomeTags.HAS_WEIRD_SKELETON_VILLAGER, new MobSpawnSettings.SpawnerData((EntityType)SREntityTypes.SKELETON_VILLAGER.get(), 25, 1, 1));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        SRBiomeModifiers.register(context, "add_spawn/" + name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), List.of(spawns)));
    }

    private static void removeSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, EntityType<?> ... types) {
        SRBiomeModifiers.register(context, "remove_spawn/" + name, () -> new ForgeBiomeModifiers.RemoveSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet)HolderSet.m_205800_(Stream.of(types).map(type -> (Holder)ForgeRegistries.ENTITY_TYPES.getHolder(type).get()).collect(Collectors.toList()))));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)SavageAndRavage.location(name)), (Object)modifier.get());
    }
}

