/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockAccessor;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;

public class DispenserHelper {
    private static final Map<Item, List<DispenseItemBehavior>> MODDED_BEHAVIORS = new HashMap<Item, List<DispenseItemBehavior>>();
    private static final Map<Item, List<DispenseItemBehavior>> STATIC_MODDED_BEHAVIORS = new HashMap<Item, List<DispenseItemBehavior>>();
    private static final Map<Priority, List<Consumer<Event>>> EVENT_LISTENERS = Map.of(Priority.LOW, new ArrayList(), Priority.NORMAL, new ArrayList(), Priority.HIGH, new ArrayList());
    public static final DefaultDispenseItemBehavior PLACE_BLOCK_BEHAVIOR = new PlaceBlockDispenseBehavior();
    private static final DefaultDispenseItemBehavior SHOOT_BEHAVIOR = new DefaultDispenseItemBehavior();

    public static void addListener(Consumer<Event> listener, Priority priority) {
        EVENT_LISTENERS.get((Object)priority).add(listener);
    }

    @ApiStatus.Internal
    public static void reload(final RegistryAccess registryAccess) {
        Item item;
        final HashSet<Item> failed = new HashSet<Item>();
        HashMap<Item, DispenseItemBehavior> originals = new HashMap<Item, DispenseItemBehavior>();
        for (Map.Entry<Item, List<DispenseItemBehavior>> entry : MODDED_BEHAVIORS.entrySet()) {
            item = entry.getKey();
            if (STATIC_MODDED_BEHAVIORS.containsKey(item)) continue;
            ReferenceOpenHashSet expected = new ReferenceOpenHashSet((Collection)entry.getValue());
            DispenseItemBehavior current = (DispenseItemBehavior)DispenserBlock.f_52661_.get(item);
            if (current instanceof AdditionalDispenserBehavior) {
                AdditionalDispenserBehavior behavior = (AdditionalDispenserBehavior)current;
                ReferenceOpenHashSet visited = new ReferenceOpenHashSet();
                DispenseItemBehavior original = DispenserHelper.unwrapBehavior(behavior, (Set<AdditionalDispenserBehavior>)visited);
                if (expected.equals((Object)visited)) {
                    originals.put(item, original);
                    continue;
                }
                Moonlight.LOGGER.warn("Failed to unwrap original behavior for item: {}, {}, {}", (Object)item, (Object)current, (Object)expected);
                failed.add(item);
                continue;
            }
            if (expected.size() == 1 && expected.stream().findAny().get() == current) {
                originals.put(item, null);
                continue;
            }
            failed.add(item);
            Moonlight.LOGGER.error("Failed to restore original behavior for item: {}, {}", (Object)item, (Object)current);
        }
        for (Map.Entry<Object, List<Object>> entry : originals.entrySet()) {
            item = (Item)entry.getKey();
            DispenseItemBehavior behavior = (DispenseItemBehavior)entry.getValue();
            if (behavior != null) {
                DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)behavior);
                continue;
            }
            DispenserBlock.f_52661_.remove(item);
        }
        MODDED_BEHAVIORS.clear();
        failed.addAll(STATIC_MODDED_BEHAVIORS.keySet());
        Event event = new Event(){

            @Override
            public void register(Item i, DispenseItemBehavior behavior) {
                if (!failed.contains(i)) {
                    MODDED_BEHAVIORS.computeIfAbsent(i, k -> new ArrayList()).add(behavior);
                    DispenserBlock.m_52672_((ItemLike)i, (DispenseItemBehavior)behavior);
                }
            }

            @Override
            public RegistryAccess getRegistryAccess() {
                return registryAccess;
            }
        };
        EVENT_LISTENERS.get((Object)Priority.LOW).forEach(l -> l.accept(event));
        EVENT_LISTENERS.get((Object)Priority.NORMAL).forEach(l -> l.accept(event));
        EVENT_LISTENERS.get((Object)Priority.HIGH).forEach(l -> l.accept(event));
    }

    private static DispenseItemBehavior unwrapBehavior(AdditionalDispenserBehavior behavior, Set<AdditionalDispenserBehavior> visited) {
        visited.add(behavior);
        DispenseItemBehavior inner = behavior.fallback;
        if (inner instanceof AdditionalDispenserBehavior) {
            AdditionalDispenserBehavior ab = (AdditionalDispenserBehavior)inner;
            return DispenserHelper.unwrapBehavior(ab, visited);
        }
        return inner;
    }

    @Deprecated(forRemoval=true)
    public static void registerCustomBehavior(AdditionalDispenserBehavior behavior) {
        DispenserBlock.m_52672_((ItemLike)behavior.item, (DispenseItemBehavior)behavior);
        STATIC_MODDED_BEHAVIORS.computeIfAbsent(behavior.item, k -> new ArrayList()).add(behavior);
    }

    @Deprecated(forRemoval=true)
    public static void registerPlaceBlockBehavior(ItemLike block) {
        DispenserBlock.m_52672_((ItemLike)block, (DispenseItemBehavior)PLACE_BLOCK_BEHAVIOR);
        STATIC_MODDED_BEHAVIORS.computeIfAbsent(block.m_5456_(), k -> new ArrayList()).add(PLACE_BLOCK_BEHAVIOR);
    }

    public static abstract class AdditionalDispenserBehavior
    implements DispenseItemBehavior {
        private final DispenseItemBehavior fallback;
        private final Item item;

        protected AdditionalDispenserBehavior(Item item) {
            this.item = item;
            this.fallback = DispenserBlockAccessor.getDispenserRegistry().get(item);
        }

        public final ItemStack m_6115_(BlockSource source, ItemStack stack) {
            try {
                InteractionResultHolder<ItemStack> result = this.customBehavior(source, stack);
                InteractionResult type = result.m_19089_();
                if (type != InteractionResult.PASS) {
                    boolean success = type.m_19077_();
                    this.playSound(source, success);
                    this.playAnimation(source, (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                    if (success) {
                        ItemStack resultStack = (ItemStack)result.m_19095_();
                        if (resultStack.m_41720_() == stack.m_41720_()) {
                            return resultStack;
                        }
                        return this.fillItemInDispenser(source, stack, (ItemStack)result.m_19095_());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.fallback.m_6115_(source, stack);
        }

        protected abstract InteractionResultHolder<ItemStack> customBehavior(BlockSource var1, ItemStack var2);

        protected void playSound(BlockSource source, boolean success) {
            source.m_7727_().m_46796_(success ? 1000 : 1001, source.m_7961_(), 0);
        }

        protected void playAnimation(BlockSource source, Direction direction) {
            source.m_7727_().m_46796_(2000, source.m_7961_(), direction.m_122411_());
        }

        private ItemStack fillItemInDispenser(BlockSource source, ItemStack empty, ItemStack filled) {
            empty.m_41774_(1);
            if (empty.m_41619_()) {
                return filled.m_41777_();
            }
            if (!this.mergeDispenserItem((DispenserBlockEntity)source.m_8118_(), filled)) {
                SHOOT_BEHAVIOR.m_6115_(source, filled.m_41777_());
            }
            return empty;
        }

        private boolean mergeDispenserItem(DispenserBlockEntity te, ItemStack filled) {
            NonNullList<ItemStack> stacks = ((DispenserBlockEntityAccessor)te).getItems();
            for (int i = 0; i < te.m_6643_(); ++i) {
                ItemStack s = (ItemStack)stacks.get(i);
                if (!s.m_41619_() && (s.m_41720_() != filled.m_41720_() || s.m_41741_() <= s.m_41613_())) continue;
                filled.m_41769_(s.m_41613_());
                te.m_6836_(i, filled);
                return true;
            }
            return false;
        }
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH;

    }

    public static interface Event {
        public void register(Item var1, DispenseItemBehavior var2);

        default public void register(AdditionalDispenserBehavior behavior) {
            this.register(behavior.item, behavior);
        }

        default public void registerPlaceBlock(ItemLike i) {
            this.register(i.m_5456_(), (DispenseItemBehavior)PLACE_BLOCK_BEHAVIOR);
        }

        public RegistryAccess getRegistryAccess();
    }

    public static class PlaceBlockDispenseBehavior
    extends OptionalDispenseItemBehavior {
        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            this.m_123573_(false);
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = source.m_7961_().m_121945_(direction);
                Direction direction1 = direction;
                InteractionResult result = bi.m_40576_((BlockPlaceContext)new DirectionalPlaceContext((Level)source.m_7727_(), blockpos, direction, stack, direction1));
                this.m_123573_(result.m_19077_());
            }
            return stack;
        }
    }

    public static class FillFluidHolderBehavior
    extends AdditionalDispenserBehavior {
        public FillFluidHolderBehavior(Item item) {
            super(item);
        }

        @Override
        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            BlockEntity te = source.m_7727_().m_7702_(blockpos);
            if (te instanceof ISoftFluidTankProvider) {
                ItemStack returnStack;
                SoftFluidTank tank;
                ISoftFluidTankProvider tile = (ISoftFluidTankProvider)te;
                if (tile.canInteractWithSoftFluidTank() && !(tank = tile.getSoftFluidTank()).isFull() && (returnStack = tank.interactWithItem(stack, (Level)source.m_7727_(), blockpos, false)) != null) {
                    te.m_6596_();
                    return InteractionResultHolder.m_19090_((Object)returnStack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    public static class AddItemToInventoryBehavior
    extends AdditionalDispenserBehavior {
        public AddItemToInventoryBehavior(Item item) {
            super(item);
        }

        @Override
        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockEntity te = world.m_7702_(blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            if (te instanceof WorldlyContainer) {
                WorldlyContainer tile = (WorldlyContainer)te;
                if (tile.m_7013_(0, stack)) {
                    if (tile.m_7983_()) {
                        tile.m_6836_(0, stack.m_41620_(1));
                    } else {
                        tile.m_8020_(0).m_41769_(1);
                        stack.m_41774_(1);
                    }
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }
}

