/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc.shadow.kaleido.lib.quiltconfig.api.metadata;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import link.e4mc.shadow.kaleido.lib.quiltconfig.api.metadata.MetadataContainer;
import link.e4mc.shadow.kaleido.lib.quiltconfig.api.values.ConfigSerializableObject;
import link.e4mc.shadow.kaleido.lib.quiltconfig.api.values.TrackedValue;

public final class MetadataType<T, B extends Builder<T>> {
    private final Supplier<Optional<T>> defaultValueSupplier;
    private final Function<Type, Optional<T>> trackedValueDefaultValueSupplier;
    private final Supplier<B> builderSupplier;
    private final boolean inherited;

    private MetadataType(Supplier<Optional<T>> defaultValueSupplier, Function<Type, Optional<T>> trackedValueDefaultValueSupplier, Supplier<B> builderSupplier, boolean inherited) {
        this.defaultValueSupplier = defaultValueSupplier;
        this.trackedValueDefaultValueSupplier = trackedValueDefaultValueSupplier;
        this.builderSupplier = builderSupplier;
        this.inherited = inherited;
    }

    public Optional<T> getDefaultValue(MetadataContainer container) {
        if (container instanceof TrackedValue) {
            Object defaultValue = ((TrackedValue)container).getDefaultValue();
            if (defaultValue instanceof ConfigSerializableObject) {
                defaultValue = ((ConfigSerializableObject)defaultValue).getRepresentation();
            }
            return this.trackedValueDefaultValueSupplier.apply(defaultValue.getClass());
        }
        return this.defaultValueSupplier.get();
    }

    public B newBuilder() {
        return (B)((Builder)this.builderSupplier.get());
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public static <T, B extends Builder<T>> MetadataType<T, B> create(Supplier<Optional<T>> defaultSupplier, Function<Type, Optional<T>> trackedValueDefaultFunction, Supplier<B> builderSupplier) {
        return new MetadataType<T, B>(defaultSupplier, trackedValueDefaultFunction, builderSupplier, false);
    }

    public static <T, B extends Builder<T>> MetadataType<T, B> create(Supplier<Optional<T>> defaultSupplier, Supplier<B> builderSupplier) {
        return MetadataType.create(defaultSupplier, builderSupplier, false);
    }

    public static <T, B extends Builder<T>> MetadataType<T, B> create(Supplier<B> builderSupplier) {
        return MetadataType.create(builderSupplier, false);
    }

    public static <T, B extends Builder<T>> MetadataType<T, B> create(Supplier<Optional<T>> defaultSupplier, Function<Type, Optional<T>> trackedValueDefaultFunction, Supplier<B> builderSupplier, boolean inherited) {
        return new MetadataType<T, B>(defaultSupplier, trackedValueDefaultFunction, builderSupplier, inherited);
    }

    public static <T, B extends Builder<T>> MetadataType<T, B> create(Supplier<Optional<T>> defaultSupplier, Supplier<B> builderSupplier, boolean inherited) {
        return new MetadataType<T, B>(defaultSupplier, t -> (Optional)defaultSupplier.get(), builderSupplier, inherited);
    }

    public static <T, B extends Builder<T>> MetadataType<T, B> create(Supplier<B> builderSupplier, boolean inherited) {
        return MetadataType.create(Optional::empty, builderSupplier, inherited);
    }

    public static interface Builder<T> {
        public T build();
    }
}

