/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.incubator.codec.quic.QuicClientSessionCache;
import io.netty.incubator.codec.quic.QuicheQuicSslEngine;
import io.netty.incubator.codec.quic.QuicheQuicSslEngineMap;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

final class BoringSSLSessionCallback {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BoringSSLSessionCallback.class);
    private final QuicClientSessionCache sessionCache;
    private final QuicheQuicSslEngineMap engineMap;

    BoringSSLSessionCallback(QuicheQuicSslEngineMap engineMap, @Nullable QuicClientSessionCache sessionCache) {
        this.engineMap = engineMap;
        this.sessionCache = sessionCache;
    }

    void newSession(long ssl, long creationTime, long timeout, byte[] session, boolean isSingleUse, byte @Nullable [] peerParams) {
        byte[] quicSession;
        if (this.sessionCache == null) {
            return;
        }
        QuicheQuicSslEngine engine = this.engineMap.get(ssl);
        if (engine == null) {
            logger.warn("engine is null ssl: {}", (Object)ssl);
            return;
        }
        if (peerParams == null) {
            peerParams = EmptyArrays.EMPTY_BYTES;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ssl: {}, session: {}, peerParams: {}", new Object[]{ssl, Arrays.toString(session), Arrays.toString(peerParams)});
        }
        if ((quicSession = BoringSSLSessionCallback.toQuicheQuicSession(session, peerParams)) != null) {
            logger.debug("save session host={}, port={}", (Object)engine.getSession().getPeerHost(), (Object)engine.getSession().getPeerPort());
            this.sessionCache.saveSession(engine.getSession().getPeerHost(), engine.getSession().getPeerPort(), TimeUnit.SECONDS.toMillis(creationTime), TimeUnit.SECONDS.toMillis(timeout), quicSession, isSingleUse);
        }
    }

    /*
     * Loose catch block
     */
    private static byte @Nullable [] toQuicheQuicSession(byte @Nullable [] sslSession, byte @Nullable [] peerParams) {
        if (sslSession != null && peerParams != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    byte[] byArray;
                    DataOutputStream dos;
                    ByteArrayOutputStream bos;
                    block19: {
                        block18: {
                            bos = new ByteArrayOutputStream();
                            dos = new DataOutputStream(bos);
                            dos.writeLong(sslSession.length);
                            dos.write(sslSession);
                            dos.writeLong(peerParams.length);
                            dos.write(peerParams);
                            byArray = bos.toByteArray();
                            if (dos == null) break block18;
                            dos.close();
                        }
                        if (bos == null) break block19;
                        bos.close();
                    }
                    return byArray;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (dos != null) {
                                    dos.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (bos != null) {
                                    bos.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

