/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import javax.annotation.Nullable;

public class ObjectModifierSerializerRegistry<T, S, D> {
    private final BiMap<String, ObjectModifier.Serializer<? extends ObjectModifier<T, S, D, ?>, S, D>> serializers = HashBiMap.create();

    public synchronized <M extends ObjectModifier<T, S, D, M>, MS extends ObjectModifier.Serializer<M, S, D>> MS register(String name, MS serializer) {
        if (this.serializers.containsKey((Object)name)) {
            throw new IllegalArgumentException("A modifier serializer with name '" + name + "' is already registered!");
        }
        this.serializers.put((Object)name, serializer);
        return serializer;
    }

    @Nullable
    public ObjectModifier.Serializer<? extends ObjectModifier<T, S, D, ?>, S, D> getSerializer(String name) {
        return (ObjectModifier.Serializer)this.serializers.get((Object)name);
    }

    @Nullable
    public String getName(ObjectModifier.Serializer<? extends ObjectModifier<T, S, D, ?>, S, D> serializer) {
        return (String)this.serializers.inverse().get(serializer);
    }
}

