/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.data.client;

import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public abstract class BlueprintItemModelProvider
extends ItemModelProvider {
    public BlueprintItemModelProvider(PackOutput output, String modid, ExistingFileHelper helper) {
        super(output, modid, helper);
    }

    public ItemModelBuilder item(RegistryObject<? extends ItemLike> item, String type) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BlueprintItemModelProvider.name((ItemLike)item.get()), "item/" + type)).texture("layer0", BlueprintItemModelProvider.itemTexture((ItemLike)item.get()));
    }

    public ItemModelBuilder item(RegistryObject<? extends ItemLike> item, String path, String type) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BlueprintItemModelProvider.name((ItemLike)item.get()), "item/" + type)).texture("layer0", new ResourceLocation(this.modid, "item/" + path));
    }

    public ItemModelBuilder item(ResourceLocation location, String type) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(location.m_135815_(), "item/" + type)).texture("layer0", new ResourceLocation(this.modid, "item/" + location.m_135815_()));
    }

    public ItemModelBuilder blockItem(RegistryObject<Block> block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BlueprintBlockStateProvider.name((Block)block.get()))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(this.modid, "block/" + BlueprintBlockStateProvider.name((Block)block.get()))));
    }

    @SafeVarargs
    public final void generatedItem(RegistryObject<? extends ItemLike> ... items) {
        for (RegistryObject<? extends ItemLike> item : items) {
            this.item(item, "generated");
        }
    }

    @SafeVarargs
    public final void handheldItem(RegistryObject<? extends ItemLike> ... items) {
        for (RegistryObject<? extends ItemLike> item : items) {
            this.item(item, "handheld");
        }
    }

    @SafeVarargs
    public final void spawnEggItem(RegistryObject<? extends ItemLike> ... items) {
        for (RegistryObject<? extends ItemLike> item : items) {
            this.withExistingParent(BlueprintItemModelProvider.name((ItemLike)item.get()), "item/template_spawn_egg");
        }
    }

    public void animatedItem(RegistryObject<? extends ItemLike> item, int count) {
        for (int i = 0; i < count; ++i) {
            String path = BlueprintItemModelProvider.name((ItemLike)item.get()) + "_" + String.format("%02d", i);
            ((ItemModelBuilder)this.withExistingParent(path, "item/generated")).texture("layer0", new ResourceLocation(this.modid, "item/" + path));
        }
    }

    @SafeVarargs
    public final void trimmableArmorItem(RegistryObject<? extends ItemLike> ... items) {
        for (RegistryObject<? extends ItemLike> item : items) {
            Item item2 = ((ItemLike)item.get()).m_5456_();
            if (!(item2 instanceof ArmorItem)) continue;
            ArmorItem armor = (ArmorItem)item2;
            ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)armor);
            ItemModelBuilder itemModel = this.item(item, "generated");
            int trimType = 1;
            for (String trim : new String[]{"quartz", "iron", "netherite", "redstone", "copper", "gold", "emerald", "diamond", "lapis", "amethyst"}) {
                ResourceLocation name = new ResourceLocation(location.m_135827_(), "item/" + location.m_135815_() + "_" + trim + "_trim");
                itemModel.override().model((ModelFile)new ModelFile.UncheckedModelFile(name)).predicate(new ResourceLocation("trim_type"), (float)((double)trimType / 10.0));
                ResourceLocation texture = new ResourceLocation("trims/items/" + armor.m_266204_().m_266355_() + "_trim_" + trim);
                this.existingFileHelper.trackGenerated(texture, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name.m_135815_(), "item/generated")).texture("layer0", new ResourceLocation(this.modid, "item/" + location.m_135815_()))).texture("layer1", texture);
                ++trimType;
            }
        }
    }

    public static ResourceLocation key(ItemLike item) {
        return ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
    }

    public static String name(ItemLike item) {
        return BlueprintItemModelProvider.key(item).m_135815_();
    }

    public static ResourceLocation itemTexture(ItemLike item) {
        ResourceLocation name = BlueprintItemModelProvider.key(item);
        return new ResourceLocation(name.m_135827_(), "item/" + name.m_135815_());
    }
}

