/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.infrastructure.data.recipe;

import com.google.common.base.Supplier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.foundation.data.recipe.CompatMetals;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.davio.aquaticambitions.infrastructure.data.recipe.CAARecipeProvider;
import net.davio.aquaticambitions.registry.CAABlocks;
import net.davio.aquaticambitions.registry.CAAItems;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import org.jetbrains.annotations.NotNull;

public class CAAStandardRecipeGen
extends BaseRecipeProvider {
    final List<BaseRecipeProvider.GeneratedRecipe> all = new ArrayList<BaseRecipeProvider.GeneratedRecipe>();
    private Marker MATERIALS = this.enterFolder("materials");
    BaseRecipeProvider.GeneratedRecipe PRISMARINE_ALLOY_FROM_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CAAItems.PRISMARINE_ALLOY).withSuffix("_from_block").returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::prismarineAlloy)).viaShapeless(b -> b.m_126209_((ItemLike)CAABlocks.PRISMARINE_ALLOY_BLOCK.get()));
    BaseRecipeProvider.GeneratedRecipe PRISMARINE_ALLOY_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CAABlocks.PRISMARINE_ALLOY_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::prismarineAlloy)).viaShaped(b -> b.m_126127_(Character.valueOf('C'), CAARecipeProvider.I.prismarineAlloy()).m_126130_("CCC").m_126130_("CCC").m_126130_("CCC"));
    BaseRecipeProvider.GeneratedRecipe PRISMARINE_ROD = this.create((ItemProviderEntry<? extends ItemLike>)CAAItems.PRISMARINE_ALLOY_ROD).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::prismarineAlloy)).viaShaped(b -> b.m_126127_(Character.valueOf('I'), CAARecipeProvider.I.prismarineAlloy()).m_126130_("I").m_126130_("I"));
    BaseRecipeProvider.GeneratedRecipe PRISMARINE_ALLOY = this.create((ItemProviderEntry<? extends ItemLike>)CAAItems.PRISMARINE_ALLOY).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::copperNugget)).viaShaped(b -> b.m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42192_).m_126127_(Character.valueOf('B'), (ItemLike)AllItems.COPPER_NUGGET).m_126130_("BA").m_126130_("AB"));
    BaseRecipeProvider.GeneratedRecipe BRAIN_CORAL = this.create((Supplier<ItemLike>)((Supplier)() -> Items.f_42286_)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::brainCoral)).viaShaped(b -> b.m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42291_).m_126130_("##").m_126130_("##"));
    BaseRecipeProvider.GeneratedRecipe FIRE_CORAL = this.create((Supplier<ItemLike>)((Supplier)() -> Items.f_42288_)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::fireCoral)).viaShaped(b -> b.m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42293_).m_126130_("##").m_126130_("##"));
    BaseRecipeProvider.GeneratedRecipe BUBBLE_CORAL = this.create((Supplier<ItemLike>)((Supplier)() -> Items.f_42287_)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::bubbleCoral)).viaShaped(b -> b.m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42292_).m_126130_("##").m_126130_("##"));
    BaseRecipeProvider.GeneratedRecipe HORN_CORAL = this.create((Supplier<ItemLike>)((Supplier)() -> Items.f_42289_)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::hornCoral)).viaShaped(b -> b.m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42294_).m_126130_("##").m_126130_("##"));
    BaseRecipeProvider.GeneratedRecipe TUBE_CORAL = this.create((Supplier<ItemLike>)((Supplier)() -> Items.f_42285_)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::tubeCoral)).viaShaped(b -> b.m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42290_).m_126130_("##").m_126130_("##"));
    BaseRecipeProvider.GeneratedRecipe MECHANICAL_CONDUIT = this.create((ItemProviderEntry<? extends ItemLike>)CAABlocks.MECHANICAL_CONDUIT).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::conduit)).viaShaped(b -> b.m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42364_.m_5456_()).m_126127_(Character.valueOf('I'), CAAItems.PRISMARINE_ALLOY_ROD).m_126127_(Character.valueOf('P'), CAARecipeProvider.I.prismarineAlloy()).m_126127_(Character.valueOf('U'), (ItemLike)AllBlocks.FLUID_PIPE).m_126130_("III").m_126130_("IAI").m_126130_("PUP"));
    BaseRecipeProvider.GeneratedRecipe TRIDENT = this.create((Supplier<ItemLike>)((Supplier)() -> Items.f_42713_)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CAARecipeProvider.I::prismarineAlloy)).viaShaped(b -> b.m_126127_(Character.valueOf('A'), (ItemLike)CAAItems.SPIKY_SHELL.get()).m_126127_(Character.valueOf('I'), (ItemLike)CAAItems.PRISMARINE_ALLOY_ROD.get()).m_126130_(" AA").m_126130_(" IA").m_126130_("I  "));
    private Marker COOKING = this.enterFolder("/");
    BaseRecipeProvider.GeneratedRecipe VERIDIUM = this.create((Supplier<ItemLike>)((Supplier)() -> (ItemLike)AllPaletteStoneTypes.VERIDIUM.baseBlock.get())).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> Items.f_42192_)).inFurnace();
    String currentFolder = "";

    Marker enterFolder(String folder) {
        this.currentFolder = folder;
        return new Marker();
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    BaseRecipeProvider.GeneratedRecipe createSpecial(Supplier<? extends SimpleCraftingRecipeSerializer<?>> serializer, String recipeType, String path) {
        ResourceLocation location = Create.asResource((String)(recipeType + "/" + this.currentFolder + "/" + path));
        return this.register(consumer -> {
            SpecialRecipeBuilder b = SpecialRecipeBuilder.m_245676_((RecipeSerializer)((RecipeSerializer)serializer.get()));
            b.m_126359_(consumer, location.toString());
        });
    }

    BaseRecipeProvider.GeneratedRecipe blastCrushedMetal(Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> ingredient) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get())).withSuffix("_from_crushed").viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).rewardXP(0.1f).inBlastFurnace();
    }

    BaseRecipeProvider.GeneratedRecipe blastModdedCrushedMetal(ItemEntry<? extends Item> ingredient, CompatMetals metal) {
        for (Mods mod : metal.getMods()) {
            String metalName = metal.getName(mod);
            ResourceLocation ingot = mod.ingotOf(metalName);
            String modId = mod.getId();
            this.create(ingot).withSuffix("_compat_" + modId).whenModLoaded(modId).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).rewardXP(0.1f).inBlastFurnace();
        }
        return null;
    }

    BaseRecipeProvider.GeneratedRecipe recycleGlass(BlockEntry<? extends Block> ingredient) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> Blocks.f_50058_)).withSuffix("_from_" + ingredient.getId().m_135815_()).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).forDuration(50).inFurnace();
    }

    BaseRecipeProvider.GeneratedRecipe recycleGlassPane(BlockEntry<? extends Block> ingredient) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> Blocks.f_50185_)).withSuffix("_from_" + ingredient.getId().m_135815_()).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).forDuration(50).inFurnace();
    }

    BaseRecipeProvider.GeneratedRecipe metalCompacting(List<ItemProviderEntry<? extends ItemLike>> variants, List<Supplier<TagKey<Item>>> ingredients) {
        BaseRecipeProvider.GeneratedRecipe result = null;
        int i = 0;
        while (i + 1 < variants.size()) {
            ItemProviderEntry<? extends ItemLike> currentEntry = variants.get(i);
            ItemProviderEntry<? extends ItemLike> nextEntry = variants.get(i + 1);
            Supplier<TagKey<Item>> currentIngredient = ingredients.get(i);
            Supplier<TagKey<Item>> nextIngredient = ingredients.get(i + 1);
            result = this.create(nextEntry).withSuffix("_from_compacting").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).viaShaped(b -> b.m_126130_("###").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), (TagKey)currentIngredient.get()));
            result = this.create(currentEntry).returns(9).withSuffix("_from_decompacting").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> nextEntry.get())).viaShapeless(b -> b.m_206419_((TagKey)nextIngredient.get()));
            ++i;
        }
        return result;
    }

    BaseRecipeProvider.GeneratedRecipe conversionCycle(List<ItemProviderEntry<? extends ItemLike>> cycle) {
        BaseRecipeProvider.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends ItemLike> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends ItemLike> nextEntry = cycle.get((i + 1) % cycle.size());
            result = this.create(nextEntry).withSuffix("_from_conversion").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).viaShapeless(b -> b.m_126209_((ItemLike)currentEntry.get()));
        }
        return result;
    }

    BaseRecipeProvider.GeneratedRecipe clearData(ItemProviderEntry<? extends ItemLike> item) {
        return this.create(item).withSuffix("_clear").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> item.get())).viaShapeless(b -> b.m_126209_((ItemLike)item.get()));
    }

    protected void m_245200_(Consumer<FinishedRecipe> p_200404_1_) {
        this.all.forEach(c -> c.register(p_200404_1_));
        Create.LOGGER.info(this.m_6055_() + " registered " + this.all.size() + " recipe" + (this.all.size() == 1 ? "" : "s"));
    }

    protected BaseRecipeProvider.GeneratedRecipe register(BaseRecipeProvider.GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    public CAAStandardRecipeGen(PackOutput p_i48262_1_) {
        super(p_i48262_1_, "create");
    }

    static class Marker {
        Marker() {
        }
    }

    class GeneratedRecipeBuilder {
        private String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        List<ICondition> recipeConditions;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ICondition>();
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        BaseRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return CAAStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CAAStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return CAAStandardRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CAAStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(result -> consumer.accept(!this.recipeConditions.isEmpty() ? new ConditionSupportingShapelessRecipeResult((FinishedRecipe)result, this.recipeConditions) : result), this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Supplier<Ingredient> upgradeMaterial) {
            return CAAStandardRecipeGen.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)RecipeCategory.COMBAT, (Item)((ItemLike)this.result.get()).m_5456_());
                b.m_266439_("has_item", (CriterionTriggerInstance)CAAStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)base.get()}).m_45077_()}));
                b.m_266371_(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return Create.asResource((String)(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix));
        }

        private ResourceLocation createLocation(String recipeType) {
            return Create.asResource((String)(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix));
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)this.result.get()).m_5456_()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;
            private final RecipeSerializer<? extends AbstractCookingRecipe> FURNACE = RecipeSerializer.f_44091_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> SMOKER = RecipeSerializer.f_44093_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> BLAST = RecipeSerializer.f_44092_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> CAMPFIRE = RecipeSerializer.f_44094_;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private BaseRecipeProvider.GeneratedRecipe create(RecipeSerializer<? extends AbstractCookingRecipe> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return CAAStandardRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247607_((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.f_42329_ : (ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)CAAStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(result -> consumer.accept(isOtherMod ? new ModdedCookingRecipeResult((FinishedRecipe)result, GeneratedRecipeBuilder.this.compatDatagenOutput, GeneratedRecipeBuilder.this.recipeConditions) : result), GeneratedRecipeBuilder.this.createSimpleLocation(CatnipServices.REGISTRIES.getKeyOrThrow(serializer).m_135815_()));
                });
            }
        }
    }

    private record ConditionSupportingShapelessRecipeResult(FinishedRecipe wrapped, List<ICondition> conditions) implements FinishedRecipe
    {
        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(@NotNull JsonObject pJson) {
            this.wrapped.m_7917_(pJson);
            JsonArray conds = new JsonArray();
            this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            pJson.add("conditions", (JsonElement)conds);
        }
    }

    private record ModdedCookingRecipeResult(FinishedRecipe wrapped, ResourceLocation outputOverride, List<ICondition> conditions) implements FinishedRecipe
    {
        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(JsonObject object) {
            this.wrapped.m_7917_(object);
            object.addProperty("result", this.outputOverride.toString());
            JsonArray conds = new JsonArray();
            this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            object.add("conditions", (JsonElement)conds);
        }
    }
}

