/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.content.processing.conduit;

import com.simibubi.create.AllFluids;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.AngleHelper;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlock;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitEffect;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitModeSlot;
import net.davio.aquaticambitions.infrastructure.config.CAAConfigs;
import net.davio.aquaticambitions.registry.CAAIcons;
import net.davio.aquaticambitions.registry.CAATags;
import net.davio.aquaticambitions.util.CAALang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MechanicalConduitBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final int TANK_CAPACITY = 1000;
    private SmartFluidTankBehaviour tank;
    private int awakenedTicks = 0;
    private final int awakenedTicksLimit;
    Map<String, MechanicalConduitEffect> conduitEffectsMap;
    protected LerpedFloat eyeAnimation;
    protected LerpedFloat eyeAngle;
    protected LerpedFloat cageAngle;
    protected ScrollOptionBehaviour<EntitySelectionMode> entityTypeSelector;

    public MechanicalConduitBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.awakenedTicksLimit = 20 * (Integer)CAAConfigs.server().conduitCage.awakenedTimeLimit.get();
        this.conduitEffectsMap = new HashMap<String, MechanicalConduitEffect>();
        this.conduitEffectsMap.put("CONDUIT_POWER", new MechanicalConduitEffect("effect.minecraft.conduit_power", MobEffects.f_19592_, 1950417, CAATags.CAAFluidTags.CONDUIT_FUEL.tag));
        this.conduitEffectsMap.put("CLEAR", new MechanicalConduitEffect("tooltip.create_aquatic_ambitions.effect.cleansing", null, 0xFFFFFF, Tags.Fluids.MILK));
        this.conduitEffectsMap.put("BURNING", new MechanicalConduitEffect("tooltip.create_aquatic_ambitions.effect.burning", null, 0xE2AA22, CAATags.CAAFluidTags.SETS_ON_FIRE.tag));
        this.conduitEffectsMap.put("SATURATION", new MechanicalConduitEffect("effect.minecraft.saturation", MobEffects.f_19618_, 16262177, CAATags.CAAFluidTags.GIVES_SATURATION.tag));
        this.conduitEffectsMap.put("FIRE_RESISTANCE", new MechanicalConduitEffect("effect.minecraft.fire_resistance", MobEffects.f_19607_, 14981690, CAATags.CAAFluidTags.GIVES_FIRE_RES.tag));
        this.conduitEffectsMap.put("HASTE", new MechanicalConduitEffect("effect.minecraft.haste", MobEffects.f_19598_, 14270531, CAATags.CAAFluidTags.GIVES_HASTE.tag));
        this.conduitEffectsMap.put("INVISIBILITY", new MechanicalConduitEffect("effect.minecraft.invisibility", MobEffects.f_19609_, 8356754, CAATags.CAAFluidTags.GIVES_INVIS.tag));
        this.conduitEffectsMap.put("JUMP_BOOST", new MechanicalConduitEffect("effect.minecraft.jump_boost", MobEffects.f_19603_, 2358349, CAATags.CAAFluidTags.GIVES_JUMP.tag));
        this.conduitEffectsMap.put("LUCK", new MechanicalConduitEffect("effect.minecraft.luck", MobEffects.f_19621_, 0x339900, CAATags.CAAFluidTags.GIVES_LUCK.tag));
        this.conduitEffectsMap.put("NIGHT_VISION", new MechanicalConduitEffect("effect.minecraft.night_vision", MobEffects.f_19611_, 0x1F1FA1, CAATags.CAAFluidTags.GIVES_NIGHT_VISION.tag));
        this.conduitEffectsMap.put("POISON", new MechanicalConduitEffect("effect.minecraft.poison", MobEffects.f_19614_, 5149489, CAATags.CAAFluidTags.GIVES_POISON.tag));
        this.conduitEffectsMap.put("REGENERATION", new MechanicalConduitEffect("effect.minecraft.regeneration", MobEffects.f_19605_, 13458603, CAATags.CAAFluidTags.GIVES_REGEN.tag));
        this.conduitEffectsMap.put("RESISTANCE", new MechanicalConduitEffect("effect.minecraft.resistance", MobEffects.f_19606_, 9389549, CAATags.CAAFluidTags.GIVES_RESISTANCE.tag));
        this.conduitEffectsMap.put("SLOW_FALLING", new MechanicalConduitEffect("effect.minecraft.slow_falling", MobEffects.f_19591_, 16773073, CAATags.CAAFluidTags.GIVES_SLOW_FALL.tag));
        this.conduitEffectsMap.put("SLOWNESS", new MechanicalConduitEffect("effect.minecraft.slowness", MobEffects.f_19597_, 5926017, CAATags.CAAFluidTags.GIVES_SLOWNESS.tag));
        this.conduitEffectsMap.put("SPEED", new MechanicalConduitEffect("effect.minecraft.speed", MobEffects.f_19596_, 8171462, CAATags.CAAFluidTags.GIVES_SPEED.tag));
        this.conduitEffectsMap.put("STRENGTH", new MechanicalConduitEffect("effect.minecraft.strength", MobEffects.f_19600_, 16565504, CAATags.CAAFluidTags.GIVES_STRENGTH.tag));
        this.conduitEffectsMap.put("WATER_BREATHING", new MechanicalConduitEffect("effect.minecraft.water_breathing", MobEffects.f_19608_, 9885630, CAATags.CAAFluidTags.GIVES_WATER_BREATHING.tag));
        this.conduitEffectsMap.put("WEAKNESS", new MechanicalConduitEffect("effect.minecraft.weakness", MobEffects.f_19613_, 0x484D48, CAATags.CAAFluidTags.GIVES_WEAKNESS.tag));
        this.conduitEffectsMap.put("WITHER", new MechanicalConduitEffect("effect.minecraft.wither", MobEffects.f_19615_, 3484199, CAATags.CAAFluidTags.GIVES_WITHER.tag));
        this.eyeAnimation = LerpedFloat.linear();
        this.eyeAngle = LerpedFloat.angular();
        this.cageAngle = LerpedFloat.angular();
        this.eyeAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)Direction.NORTH) + 180.0f) % 360.0f));
        this.cageAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)Direction.NORTH) + 180.0f) % 360.0f));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true).whenFluidUpdates(this::consumeFluid).forbidExtraction();
        behaviours.add((BlockEntityBehaviour)this.tank);
        this.entityTypeSelector = new ScrollOptionBehaviour(EntitySelectionMode.class, (Component)CAALang.translateDirect("mechanical_conduit.entity_filter.title", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MechanicalConduitModeSlot());
        behaviours.add((BlockEntityBehaviour)this.entityTypeSelector);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.DOWN) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    private void consumeFluid() {
        FluidStack fluidStack = this.tank.getPrimaryHandler().getFluid();
        for (MechanicalConduitEffect conduitEffect : this.conduitEffectsMap.values()) {
            if (fluidStack.getFluid().m_205067_(conduitEffect.getFluidTag()) || this.potionHasEffect(fluidStack, conduitEffect)) {
                conduitEffect.addTicks(this.getConversionRate(fluidStack) * (float)fluidStack.getAmount());
            }
            if (conduitEffect.getTicks() <= this.awakenedTicksLimit) continue;
            this.tank.forbidInsertion();
        }
        this.tank.getPrimaryHandler().drain(1000, IFluidHandler.FluidAction.EXECUTE);
        this.notifyUpdate();
        this.updateBlockState();
        this.sendData();
    }

    private boolean potionHasEffect(FluidStack fluidStack, MechanicalConduitEffect conduitEffect) {
        Potion potion;
        ResourceLocation potionId;
        CompoundTag tag = fluidStack.getTag();
        if (tag == null) {
            return false;
        }
        if (tag.m_128425_("CustomPotionEffects", 9)) {
            ListTag effectsList = tag.m_128437_("CustomPotionEffects", 10);
            for (int i = 0; i < effectsList.size(); ++i) {
                CompoundTag effectTag = effectsList.m_128728_(i);
                MobEffectInstance instance = MobEffectInstance.m_19560_((CompoundTag)effectTag);
                if (instance == null || instance.m_19544_() != conduitEffect.getEffect()) continue;
                conduitEffect.setAmplifier(instance.m_19564_());
                return true;
            }
        }
        if (tag.m_128425_("Potion", 8) && (potionId = ResourceLocation.m_135820_((String)tag.m_128461_("Potion"))) != null && (potion = (Potion)BuiltInRegistries.f_256980_.m_7745_(potionId)) != null) {
            for (MobEffectInstance effect : potion.m_43488_()) {
                if (effect.m_19544_() != conduitEffect.getEffect()) continue;
                conduitEffect.setAmplifier(effect.m_19564_());
                return true;
            }
        }
        return false;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            if (this.shouldTickAnimation()) {
                this.tickAnimation();
            }
            if (!this.isVirtual()) {
                this.spawnParticles(this.getConduitLevelFromBlock());
            }
            return;
        }
        int maxAwakanedTicks = 0;
        for (MechanicalConduitEffect conduitEffect : this.conduitEffectsMap.values()) {
            if (conduitEffect.isActive()) {
                conduitEffect.subtractTicks();
                if (conduitEffect.getFluidTag() == Tags.Fluids.MILK) {
                    this.clearEffects();
                } else if (conduitEffect.getFluidTag() == CAATags.CAAFluidTags.SETS_ON_FIRE.tag) {
                    this.setOnFire();
                } else {
                    this.applyEffects(conduitEffect.getEffect(), conduitEffect.getAmplifier());
                }
                if (conduitEffect.getTicks() < this.awakenedTicksLimit) {
                    this.tank.allowInsertion();
                }
                if (conduitEffect.getTicks() > maxAwakanedTicks) {
                    maxAwakanedTicks = conduitEffect.getTicks();
                }
            } else if (conduitEffect.getAmplifier() > 0) {
                conduitEffect.resetAmplifier();
            }
            this.awakenedTicks = maxAwakanedTicks;
        }
        this.updateBlockState();
        this.sendData();
    }

    public void lazyTick() {
        super.lazyTick();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("awakenedTimeRemaining", this.awakenedTicks);
        CompoundTag effectsTag = new CompoundTag();
        for (Map.Entry<String, MechanicalConduitEffect> entry : this.conduitEffectsMap.entrySet()) {
            effectsTag.m_128405_(entry.getKey(), entry.getValue().getTicks());
        }
        compound.m_128365_("ConduitEffects", (Tag)effectsTag);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.awakenedTicks = compound.m_128451_("awakenedTimeRemaining");
        super.read(compound, clientPacket);
        CompoundTag effectsTag = compound.m_128469_("ConduitEffects");
        for (String key : effectsTag.m_128431_()) {
            MechanicalConduitEffect effect = this.conduitEffectsMap.get(key);
            if (effect == null) continue;
            effect.setTicks(effectsTag.m_128451_(key));
        }
    }

    public MechanicalConduitBlock.ConduitPowerLevel getConduitLevelFromBlock() {
        return MechanicalConduitBlock.getConduitLevelOf(this.m_58900_());
    }

    public void updateBlockState() {
        this.setConduitLevelOfBlock(this.getConduitLevel());
    }

    public void setConduitLevelOfBlock(MechanicalConduitBlock.ConduitPowerLevel conduitPowerLevel) {
        MechanicalConduitBlock.ConduitPowerLevel inBlockState = this.getConduitLevelFromBlock();
        if (inBlockState == conduitPowerLevel) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(MechanicalConduitBlock.CONDUIT_POWER_LEVEL, (Comparable)((Object)conduitPowerLevel)));
        this.notifyUpdate();
    }

    protected MechanicalConduitBlock.ConduitPowerLevel getConduitLevel() {
        if (this.awakenedTicks > 0) {
            return MechanicalConduitBlock.ConduitPowerLevel.AWAKENED;
        }
        return MechanicalConduitBlock.ConduitPowerLevel.IDLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean shouldTickAnimation() {
        return !VisualizationManager.supportsVisualization((LevelAccessor)this.f_58857_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAnimation() {
        float eyeTarget = 0.0f;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !player.m_20145_()) {
            double z;
            double x;
            if (this.isVirtual()) {
                x = -4.0;
                z = -10.0;
            } else {
                x = player.m_20185_();
                z = player.m_20189_();
            }
            double dx = x - ((double)this.m_58899_().m_123341_() + 0.5);
            double dz = z - ((double)this.m_58899_().m_123343_() + 0.5);
            eyeTarget = AngleHelper.deg((double)(-Mth.m_14136_((double)dz, (double)dx))) - 90.0f;
        }
        eyeTarget = this.eyeAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.eyeAngle.getValue(), (double)eyeTarget);
        this.eyeAngle.chase((double)eyeTarget, 0.25, LerpedFloat.Chaser.exp((double)5.0));
        this.eyeAngle.tickChaser();
        this.eyeAnimation.chase(0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.eyeAnimation.tickChaser();
    }

    protected void spawnParticles(MechanicalConduitBlock.ConduitPowerLevel conduitPowerLevel) {
        if (this.f_58857_ == null) {
            return;
        }
        if (conduitPowerLevel == MechanicalConduitBlock.ConduitPowerLevel.IDLE) {
            return;
        }
        RandomSource r = this.f_58857_.m_213780_();
        if (conduitPowerLevel.isAwakened() && r.m_188503_(5) == 0) {
            Vec3 vec31 = new Vec3((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 2.0f), (double)((float)this.m_58899_().m_123343_() + 0.5f));
            float f3 = (-0.5f + r.m_188501_()) * 2.0f;
            float f4 = -1.25f + r.m_188501_();
            float f5 = (-0.5f + r.m_188501_()) * 2.0f;
            Vec3 vec32 = new Vec3((double)f3, (double)f4, (double)f5);
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123775_, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_);
        }
    }

    private void applyEffects(MobEffect effect, int amplifier) {
        int range = (Integer)CAAConfigs.server().conduitCage.conduitCageRange.get();
        List<LivingEntity> list = this.getLivingEntities(range);
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                MobEffectInstance existing;
                if (!MechanicalConduitBlockEntity.entityMatchesSelector(entity, (EntitySelectionMode)this.entityTypeSelector.get()) || !this.m_58899_().m_123314_((Vec3i)entity.m_20183_(), (double)range) || (existing = entity.m_21124_(effect)) != null && existing.m_19557_() >= 25) continue;
                entity.m_7292_(new MobEffectInstance(effect, 119, amplifier, true, true));
            }
        }
    }

    private void clearEffects() {
        int range = (Integer)CAAConfigs.server().conduitCage.conduitCageRange.get();
        List<LivingEntity> list = this.getLivingEntities(range);
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                if (!MechanicalConduitBlockEntity.entityMatchesSelector(entity, (EntitySelectionMode)this.entityTypeSelector.get()) || !this.m_58899_().m_123314_((Vec3i)entity.m_20183_(), (double)range)) continue;
                entity.m_21219_();
            }
        }
    }

    private void setOnFire() {
        int range = (Integer)CAAConfigs.server().conduitCage.conduitCageRange.get();
        List<LivingEntity> list = this.getLivingEntities(range);
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                if (!MechanicalConduitBlockEntity.entityMatchesSelector(entity, (EntitySelectionMode)this.entityTypeSelector.get()) || !this.m_58899_().m_123314_((Vec3i)entity.m_20183_(), (double)range)) continue;
                entity.m_20254_(5);
            }
        }
    }

    public List<LivingEntity> getLivingEntities(int range) {
        int k = this.m_58899_().m_123341_();
        int l = this.m_58899_().m_123342_();
        int i1 = this.m_58899_().m_123343_();
        AABB aabb = new AABB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82400_((double)range).m_82363_(0.0, (double)this.f_58857_.m_141928_(), 0.0);
        List list = this.f_58857_.m_45976_(LivingEntity.class, aabb);
        return list;
    }

    public float getConversionRate(FluidStack fluidStack) {
        float conversionRate = CAATags.CAAFluidTags.CONDUIT_FUEL.matches(fluidStack.getFluid()) ? (float)((Integer)CAAConfigs.server().conduitCage.waterAwakenConversionRate.get() * 20) / 1000.0f : (fluidStack.getFluid().m_6212_((Fluid)AllFluids.POTION.get()) ? (float)((Integer)CAAConfigs.server().conduitCage.potionAwakenConversionRate.get() * 20) / 1000.0f : (float)((Integer)CAAConfigs.server().conduitCage.fluidAwakenConversionRate.get() * 20) / 1000.0f);
        return conversionRate;
    }

    public static boolean entityMatchesSelector(LivingEntity entity, EntitySelectionMode mode) {
        if (mode == EntitySelectionMode.PLAYERS) {
            return entity instanceof Player;
        }
        if (mode == EntitySelectionMode.MONSTERS) {
            return entity instanceof Enemy;
        }
        if (mode == EntitySelectionMode.FRIENDLY_MOBS) {
            return entity instanceof PathfinderMob && !(entity instanceof Monster);
        }
        if (mode == EntitySelectionMode.PLAYERS_FRIENDLY_MOBS) {
            return entity instanceof PathfinderMob && !(entity instanceof Monster) || entity instanceof Player;
        }
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.getConduitLevel().isAwakened()) {
            return false;
        }
        CAALang.translate("tooltip.conduitcage.header", new Object[0]).forGoggles(tooltip);
        LangBuilder sec = CreateLang.translate((String)"generic.unit.seconds", (Object[])new Object[0]);
        for (MechanicalConduitEffect conduitEffect : this.conduitEffectsMap.values()) {
            MutableComponent effectName = Component.m_237115_((String)conduitEffect.getLangKey()).m_130948_(Style.f_131099_.m_178520_(conduitEffect.getColor()));
            if (!conduitEffect.isActive()) continue;
            CAALang.text("").add((Component)effectName).add(CAALang.text(" ")).add(CAALang.text(this.tickToDuration(conduitEffect.getTicks())).style(ChatFormatting.WHITE)).forGoggles(tooltip, 1);
        }
        return true;
    }

    public String tickToDuration(int tickAmount) {
        if (tickAmount > 143990) {
            return "\u221e";
        }
        int totalSeconds = tickAmount / 20;
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds / 60 % 60;
        int seconds = totalSeconds % 60;
        if (hours > 0) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static enum EntitySelectionMode implements INamedIconOptions
    {
        EVERYONE(CAAIcons.I_EVERYONE),
        PLAYERS(CAAIcons.I_PLAYERS),
        FRIENDLY_MOBS(CAAIcons.I_FRIENDLY_MOBS),
        PLAYERS_FRIENDLY_MOBS(CAAIcons.I_PLAYERS_FRIENDLY_MOBS),
        MONSTERS(CAAIcons.I_MONSTERS);

        private final String translationKey;
        private final CAAIcons icon;

        private EntitySelectionMode(CAAIcons icon) {
            this.icon = icon;
            this.translationKey = "mechanical_conduit.selection_mode." + Lang.asId((String)this.name());
        }

        public CAAIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

