/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.util;

import com.bawnorton.neruina.extend.CrashReportSectionExtender;
import com.bawnorton.neruina.platform.Platform;
import com.bawnorton.neruina.util.Reflection;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;

public final class TickingEntry {
    private final Supplier<@Nullable Object> causeSupplier;
    private final boolean persitent;
    private final ResourceKey<Level> dimension;
    private final BlockPos pos;
    private final Throwable error;
    private final UUID uuid;
    private String cachedCauseType;
    private String cachedCauseName;
    private final List<String> blacklistedModids = List.of("neruina", "minecraft", "forge", "neoforge");

    public TickingEntry(Object cause, boolean persitent, ResourceKey<Level> dimension, BlockPos pos, Throwable error) {
        this.causeSupplier = () -> cause;
        this.persitent = persitent;
        this.dimension = dimension;
        this.pos = pos;
        this.error = error;
        this.uuid = UUID.randomUUID();
        this.update();
    }

    private TickingEntry(Supplier<@Nullable Object> causeSupplier, boolean persitent, ResourceKey<Level> dimension, BlockPos pos, UUID uuid, Throwable error) {
        this.causeSupplier = causeSupplier;
        this.persitent = persitent;
        this.dimension = dimension;
        this.pos = pos;
        this.uuid = uuid;
        this.error = error;
    }

    public void populate(CrashReportCategory section) {
        section.m_128159_("Message", (Object)this.error.getMessage());
        ((CrashReportSectionExtender)section).neruin$setStacktrace(this.error);
        Object cause = this.getCause();
        if (cause instanceof Entity) {
            Entity entity = (Entity)cause;
            entity.m_7976_(section);
        } else if (cause instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)cause;
            blockEntity.m_58886_(section);
        } else if (cause instanceof BlockState) {
            BlockState state = (BlockState)cause;
            section.m_128159_("Position", (Object)this.pos);
            section.m_128159_("BlockState", (Object)state);
        } else if (cause instanceof ItemStack) {
            ItemStack stack = (ItemStack)cause;
            section.m_128159_("ItemStack", (Object)stack);
        } else {
            section.m_128159_("Errored", (Object)"Unknown");
        }
    }

    public String createCrashReport() {
        CrashReport report = new CrashReport("Ticking %s".formatted(this.getCauseType()), this.error);
        CrashReportCategory section = report.m_127514_("Source: %s".formatted(this.getCauseName()));
        this.populate(section);
        return report.m_127526_();
    }

    public Object getCause() {
        return this.causeSupplier.get();
    }

    public void update() {
        Object cause = this.causeSupplier.get();
        if (cause instanceof Entity) {
            Entity entity = (Entity)cause;
            this.cachedCauseType = Type.ENTITY.type;
            this.cachedCauseName = Type.ENTITY.nameFunction.apply(entity);
        } else if (cause instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)cause;
            this.cachedCauseType = Type.BLOCK_ENTITY.type;
            this.cachedCauseName = Type.BLOCK_ENTITY.nameFunction.apply(blockEntity);
        } else if (cause instanceof BlockState) {
            BlockState state = (BlockState)cause;
            this.cachedCauseType = Type.BLOCK_STATE.type;
            this.cachedCauseName = Type.BLOCK_STATE.nameFunction.apply(state);
        } else if (cause instanceof ItemStack) {
            ItemStack stack = (ItemStack)cause;
            this.cachedCauseType = Type.ITEM_STACK.type;
            this.cachedCauseName = Type.ITEM_STACK.nameFunction.apply(stack);
        } else {
            this.cachedCauseType = Type.UNKNOWN.type;
            this.cachedCauseName = Type.UNKNOWN.nameFunction.apply(cause);
        }
    }

    public String getCauseType() {
        return this.cachedCauseType;
    }

    public String getCauseName() {
        return this.cachedCauseName;
    }

    public Set<String> findPotentialSources() {
        StackTraceElement[] stackTrace = this.error.getStackTrace();
        HashSet<String> modids = new HashSet<String>();
        for (StackTraceElement element : stackTrace) {
            URL resource;
            String modidFromResource;
            Class<?> clazz;
            try {
                clazz = Class.forName(element.getClassName());
            }
            catch (ClassNotFoundException ignored) {
                continue;
            }
            String methodName = element.getMethodName();
            String modid = this.checkForMixin(clazz, methodName);
            if (modid != null) {
                modids.add(modid);
                continue;
            }
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null || (modidFromResource = TickingEntry.modidFromResource(resource = codeSource.getLocation())) == null) continue;
            modids.add(modidFromResource);
        }
        this.blacklistedModids.forEach(modids::remove);
        return modids;
    }

    @Nullable
    private String checkForMixin(Class<?> clazz, String methodName) {
        Method method = Reflection.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        if (!method.isAnnotationPresent(MixinMerged.class)) {
            return null;
        }
        MixinMerged annotation = method.getAnnotation(MixinMerged.class);
        String mixinClassName = annotation.mixin();
        ClassLoader classLoader = clazz.getClassLoader();
        URL resource = classLoader.getResource(mixinClassName.replace('.', '/') + ".class");
        if (resource == null) {
            return null;
        }
        return TickingEntry.modidFromResource(resource);
    }

    @Nullable
    private static String modidFromResource(URL resource) {
        String location = resource.getPath();
        int index = location.indexOf("jar");
        if (index != -1) {
            location = location.substring(0, index + "jar".length());
            String[] parts = location.split("/");
            String jarName = parts[parts.length - 1];
            return Platform.modidFromJar(jarName);
        }
        return null;
    }

    public CompoundTag writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Object cause = this.getCause();
        nbt.m_128359_("causeType", this.getCauseType());
        nbt.m_128359_("causeName", this.getCauseName());
        nbt.m_128362_("uuid", this.uuid);
        nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
        nbt.m_128356_("pos", this.pos.m_121878_());
        this.writeStackTraceNbt(nbt);
        if (cause instanceof Entity) {
            Entity entity = (Entity)cause;
            nbt.m_128362_("entityUuid", entity.m_20148_());
        }
        return nbt;
    }

    private void writeStackTraceNbt(CompoundTag nbt) {
        nbt.m_128359_("message", this.error.getMessage());
        nbt.m_128359_("exception", this.error.getClass().getName());
        ListTag stacktrace = new ListTag();
        for (StackTraceElement element : this.error.getStackTrace()) {
            CompoundTag elementNbt = new CompoundTag();
            if (element.getClassLoaderName() != null) {
                elementNbt.m_128359_("classLoaderName", element.getClassLoaderName());
            }
            if (element.getModuleName() != null) {
                elementNbt.m_128359_("moduleName", element.getModuleName());
            }
            if (element.getModuleVersion() != null) {
                elementNbt.m_128359_("moduleVersion", element.getModuleVersion());
            }
            elementNbt.m_128359_("declaringClass", element.getClassName());
            elementNbt.m_128359_("methodName", element.getMethodName());
            if (element.getFileName() != null) {
                elementNbt.m_128359_("fileName", element.getFileName());
            }
            elementNbt.m_128405_("lineNumber", element.getLineNumber());
            stacktrace.add((Object)elementNbt);
        }
        nbt.m_128365_("stacktrace", (Tag)stacktrace);
    }

    public static TickingEntry fromNbt(ServerLevel world, CompoundTag nbtCompound) {
        String causeType = nbtCompound.m_128461_("causeType");
        String causeName = nbtCompound.m_128461_("causeName");
        UUID uuid = nbtCompound.m_128342_("uuid");
        String dimensionStr = nbtCompound.m_128461_("dimension");
        ResourceKey dimension = dimensionStr != null ? ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)dimensionStr)) : Level.f_46428_;
        BlockPos pos = BlockPos.m_122022_((long)nbtCompound.m_128454_("pos"));
        Throwable error = TickingEntry.readStackTraceNbt(nbtCompound);
        Supplier<Object> cause = () -> null;
        if (causeType.equals(Type.ENTITY.type)) {
            if (nbtCompound.m_128441_("entityUuid")) {
                UUID entityUuid = nbtCompound.m_128342_("entityUuid");
                cause = () -> world.m_8791_(entityUuid);
            }
        } else if (causeType.equals(Type.BLOCK_ENTITY.type)) {
            cause = () -> world.m_7702_(pos);
        } else if (causeType.equals(Type.BLOCK_STATE.type)) {
            cause = () -> world.m_8055_(pos);
        }
        TickingEntry entry = new TickingEntry(cause, true, (ResourceKey<Level>)dimension, pos, uuid, error);
        entry.cachedCauseType = causeType;
        entry.cachedCauseName = causeName;
        return entry;
    }

    private static Throwable readStackTraceNbt(CompoundTag nbtCompound) {
        String message = nbtCompound.m_128461_("message");
        String exceptionClass = nbtCompound.m_128461_("exception");
        ListTag stacktrace = nbtCompound.m_128437_("stacktrace", 10);
        StackTraceElement[] elements = new StackTraceElement[stacktrace.size()];
        for (int i = 0; i < stacktrace.size(); ++i) {
            String moduleVersion;
            String moduleName;
            Tag nbtElement = stacktrace.get(i);
            CompoundTag compound = (CompoundTag)nbtElement;
            String classLoaderName = compound.m_128461_("classLoaderName");
            if (classLoaderName.isEmpty()) {
                classLoaderName = null;
            }
            if ((moduleName = compound.m_128461_("moduleName")).isEmpty()) {
                moduleName = null;
            }
            if ((moduleVersion = compound.m_128461_("moduleVersion")).isEmpty()) {
                moduleVersion = null;
            }
            String declaringClass = compound.m_128461_("declaringClass");
            String methodName = compound.m_128461_("methodName");
            String fileName = compound.m_128461_("fileName");
            if (fileName.isEmpty()) {
                fileName = null;
            }
            int lineNumber = compound.m_128451_("lineNumber");
            elements[i] = new StackTraceElement(classLoaderName, moduleName, moduleVersion, declaringClass, methodName, fileName, lineNumber);
        }
        return TickingEntry.createThrowable(message, exceptionClass, elements);
    }

    private static Throwable createThrowable(String message, String exceptionClass, StackTraceElement[] elements) {
        try {
            Class<?> clazz = Class.forName(exceptionClass);
            Throwable throwable = (Throwable)clazz.getConstructor(String.class).newInstance(message);
            throwable.setStackTrace(elements);
            return throwable;
        }
        catch (Exception e) {
            Throwable throwable = new Throwable(message);
            throwable.setStackTrace(elements);
            return throwable;
        }
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public Throwable error() {
        return this.error;
    }

    public boolean isPersitent() {
        return this.persitent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TickingEntry that = (TickingEntry)obj;
        return Objects.equals(this.cachedCauseName, that.cachedCauseName) && Objects.equals(this.cachedCauseType, that.cachedCauseType) && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.pos, that.pos) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.cachedCauseType, this.cachedCauseName, this.dimension, this.pos, this.uuid, this.error);
    }

    public String toString() {
        return "TickingEntry[causeType=%s, causeName=%s, dimension=%s pos=%s, uuid=%s, error=%s]".formatted(this.cachedCauseType, this.cachedCauseName, this.dimension, this.pos, this.uuid, this.error);
    }

    private record Type<T>(String type, Function<T, String> nameFunction) {
        static final Type<Entity> ENTITY = new Type<Entity>("Entity", entity -> entity.m_7755_().getString());
        static final Type<BlockEntity> BLOCK_ENTITY = new Type<BlockEntity>("BlockEntity", blockEntity -> blockEntity.m_58900_().m_60734_().m_49954_().getString());
        static final Type<BlockState> BLOCK_STATE = new Type<BlockState>("BlockState", blockState -> blockState.m_60734_().m_49954_().getString());
        static final Type<ItemStack> ITEM_STACK = new Type<ItemStack>("ItemStack", itemStack -> itemStack.m_41720_().m_41466_().getString());
        static final Type<Object> UNKNOWN = new Type<Object>("Unknown", object -> "Unknown");
    }
}

