/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.report;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.server.MinecraftServer;

public class Storage {
    private static final Gson GSON = new Gson();
    private static StorageData storageData;

    public static void init(MinecraftServer server) {
        server.m_177941_().m_214159_("storage", resource -> resource.m_135815_().equals("storage/a.json")).forEach((id, resource) -> {
            try (JsonReader reader = new JsonReader((Reader)resource.m_215508_());){
                storageData = (StorageData)GSON.fromJson(reader, StorageData.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static String get() {
        byte[] s = Base64.getDecoder().decode(Storage.storageData.stored);
        try {
            Cipher c = Cipher.getInstance("AES");
            c.init(2, new SecretKeySpec(Arrays.copyOf(s, 16), "AES"));
            return new String(c.doFinal(Base64.getDecoder().decode(Storage.storageData.data)));
        }
        catch (Exception e) {
            throw new RuntimeException("Error occured while getting data", e);
        }
    }

    private static final class StorageData {
        private final String stored;
        private final String data;

        private StorageData(String stored, String data) {
            this.stored = stored;
            this.data = data;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StorageData that = (StorageData)obj;
            return Objects.equals(this.stored, that.stored) && Objects.equals(this.data, that.data);
        }

        public int hashCode() {
            return Objects.hash(this.stored, this.data);
        }

        public String toString() {
            return "StorageData[stored=" + this.stored + ", data=" + this.data + "]";
        }
    }
}

