/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.command;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.extend.Errorable;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.report.GithubAuthManager;
import com.bawnorton.neruina.report.ReportStatus;
import com.bawnorton.neruina.util.ErroredType;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.VersionedText;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public final class NeruinaCommandHandler {
    private static final MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"neruina").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"resume").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(NeruinaCommandHandler::executeResumeEntity)))).then(Commands.m_82127_((String)"block_entity").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(NeruinaCommandHandler::executeResumeBlockEntity)))).then(Commands.m_82127_((String)"block_state").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(NeruinaCommandHandler::executeResumeBlockState)))).then(Commands.m_82127_((String)"item_stack").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91449_()).executes(NeruinaCommandHandler::executeResumeHeldItem))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"kill").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91460_()).executes(NeruinaCommandHandler::executeKill)))).then(Commands.m_82127_((String)"report").then(Commands.m_82129_((String)"id", (ArgumentType)UuidArgument.m_113850_()).executes(NeruinaCommandHandler::executeReport)))).then(Commands.m_82127_((String)"cancel_login").executes(NeruinaCommandHandler::executeCancelLogin))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"id").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(NeruinaCommandHandler::executeIdEntity))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(NeruinaCommandHandler::executeIdBlock)))).then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"id", (ArgumentType)UuidArgument.m_113850_()).executes(NeruinaCommandHandler::executeInfo)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear_tracked").requires(source -> source.m_6761_(2))).executes(NeruinaCommandHandler::executeClear))).then(Commands.m_82127_((String)"show_suspended").executes(NeruinaCommandHandler::executeShowSuspended)));
    }

    private static int executeResumeEntity(CommandContext<CommandSourceStack> context) {
        try {
            Entity entity = EntityArgument.m_91452_(context, (String)"entity");
            if (!((Errorable)entity).neruina$isErrored()) {
                ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.resume.entity.not_errored", entity.m_7755_().getString()));
                return 0;
            }
            Neruina.getInstance().getTickHandler().removeErrored(entity);
            NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.entity", entity.m_7755_().getString()));
        }
        catch (CommandSyntaxException ignored) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.resume.entity.not_found", new Object[0]));
        }
        return 1;
    }

    private static int executeResumeBlockEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_264582_(context, (String)"pos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).m_81372_().m_7702_(pos);
        if (blockEntity == null) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.resume.block_entity.not_found", messageHandler.posAsNums(pos)));
            return 0;
        }
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        LevelChunk worldChunk = world.m_46745_(pos);
        BlockState state = worldChunk.m_8055_(pos);
        Block block = state.m_60734_();
        String name = block.m_49954_().getString();
        if (!((Errorable)blockEntity).neruina$isErrored()) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.resume.block_entity.not_errored", name, messageHandler.posAsNums(pos)));
            return 0;
        }
        Neruina.getInstance().getTickHandler().removeErrored(blockEntity);
        worldChunk.m_142170_(blockEntity);
        NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.block_entity", name, messageHandler.posAsNums(pos)));
        return 1;
    }

    private static int executeResumeBlockState(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_264582_(context, (String)"pos");
        BlockState blockState = ((CommandSourceStack)context.getSource()).m_81372_().m_8055_(pos);
        String name = blockState.m_60734_().m_49954_().getString();
        if (!Neruina.getInstance().getTickHandler().isErrored(blockState, pos)) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.resume.block_state.not_errored", name, messageHandler.posAsNums(pos)));
            return 0;
        }
        Neruina.getInstance().getTickHandler().removeErrored(blockState, pos);
        NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.block_state", name, messageHandler.posAsNums(pos)));
        return 1;
    }

    private static int executeResumeHeldItem(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ItemStack stack = player.m_21120_(player.m_7655_());
            if (!((Errorable)stack).neruina$isErrored()) {
                ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.resume.item_stack.not_errored", player.m_7755_().getString(), stack.m_41786_().getString()));
                return 0;
            }
            Neruina.getInstance().getTickHandler().removeErrored(stack);
            NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.item_stack", player.m_7755_().getString(), stack.m_41786_().getString()));
        }
        catch (CommandSyntaxException ignored) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.resume.entity.not_found", new Object[0]));
        }
        return 1;
    }

    private static int executeKill(CommandContext<CommandSourceStack> context) {
        try {
            Collection entities = EntityArgument.m_91461_(context, (String)"entity");
            if (entities.size() == 1) {
                Entity entity = (Entity)entities.iterator().next();
                String name = entity.m_7755_().getString();
                if (!((Errorable)entity).neruina$isErrored()) {
                    ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.kill.not_errored", name));
                    return 0;
                }
                Neruina.getInstance().getTickHandler().killEntity(entity, messageHandler.formatText("commands.neruina.kill", name));
            } else {
                int killed = 0;
                for (Entity entity : entities) {
                    if (!((Errorable)entity).neruina$isErrored()) continue;
                    Neruina.getInstance().getTickHandler().killEntity(entity, null);
                    ++killed;
                }
                NeruinaCommandHandler.sendFeedback(context, NeruinaCommandHandler.getKilledResultMessage(entities, killed));
            }
        }
        catch (CommandSyntaxException ignored) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.kill.not_found", new Object[0]));
        }
        return 1;
    }

    private static Component getKilledResultMessage(Collection<? extends Entity> entities, int killed) {
        int missed = entities.size() - killed;
        Component message = killed == 1 && missed == 1 ? messageHandler.formatText("commands.neruina.kill.multiple.singular_singular", new Object[0]) : (killed == 1 ? messageHandler.formatText("commands.neruina.kill.multiple.singular_plural", missed) : (missed == 1 ? messageHandler.formatText("commands.neruina.kill.multiple.plural_singular", killed) : messageHandler.formatText("commands.neruina.kill.multiple", killed, missed)));
        return message;
    }

    private static int executeReport(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        UUID id = UuidArgument.m_113853_(context, (String)"id");
        TickingEntry entry = Neruina.getInstance().getTickHandler().getTickingEntry(id);
        if (entry == null) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.report.not_found", id.toString()));
            return 0;
        }
        Neruina.getInstance().getAutoReportHandler().createReports(((CommandSourceStack)context.getSource()).m_81375_(), entry).thenAccept(result -> {
            ReportStatus.Code reportCode = result.code();
            switch (reportCode) {
                case SUCCESS: {
                    NeruinaCommandHandler.sendFeedback(context, VersionedText.concatDelimited(VersionedText.LINE_BREAK, VersionedText.format(VersionedText.translatable("commands.neruina.report.success", new Object[0])), messageHandler.generateOpenReportAction(result.message())));
                    break;
                }
                case ALREADY_EXISTS: {
                    ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.report.already_exists", new Object[0]));
                    break;
                }
                case FAILURE: {
                    ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.report.failure", new Object[0]));
                    break;
                }
                case TIMEOUT: {
                    ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.report.timeout", new Object[0]));
                    break;
                }
                case ABORTED: {
                    ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.report.aborted", new Object[0]));
                    break;
                }
                case IN_PROGRESS: {
                    ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.report.in_progress", new Object[0]));
                }
            }
        });
        return 1;
    }

    private static int executeCancelLogin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean wasLoggingIn = GithubAuthManager.cancelLogin(((CommandSourceStack)context.getSource()).m_81375_());
        if (!wasLoggingIn) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.cancel.not_logging_in", new Object[0]));
            return 0;
        }
        return 1;
    }

    private static int executeIdBlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_264582_(context, (String)"pos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).m_81372_().m_7702_(pos);
        Neruina.getInstance().getTickHandler().getTickingEntryId(blockEntity).ifPresentOrElse(uuid -> NeruinaCommandHandler.sendFeedback(context, VersionedText.withStyle(messageHandler.formatText("commands.neruina.id", uuid.toString()), style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)VersionedText.translatable("commands.neruina.id.tooltip", new Object[0]))))), () -> ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.id.block.not_errored", ((CommandSourceStack)context.getSource()).m_81372_().m_8055_(pos).m_60734_().m_49954_().getString(), messageHandler.posAsNums(pos))));
        return 1;
    }

    private static int executeIdEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = player.m_21120_(player.m_7655_());
            tickHandler.getTickingEntryId(stack).ifPresentOrElse(uuid -> NeruinaCommandHandler.sendFeedback(context, VersionedText.withStyle(messageHandler.formatText("commands.neruina.id", uuid.toString()), style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)VersionedText.translatable("commands.neruina.id.tooltip", new Object[0]))))), () -> ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.id.item_stack.not_errored", player.m_7755_().getString(), stack.m_41786_().getString())));
        } else {
            tickHandler.getTickingEntryId(entity).ifPresentOrElse(uuid -> NeruinaCommandHandler.sendFeedback(context, VersionedText.withStyle(messageHandler.formatText("commands.neruina.id", uuid.toString()), style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)VersionedText.translatable("commands.neruina.id.tooltip", new Object[0]))))), () -> ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.id.entity.not_errored", entity.m_7755_().getString())));
        }
        return 1;
    }

    private static int executeInfo(CommandContext<CommandSourceStack> context) {
        UUID id = UuidArgument.m_113853_(context, (String)"id");
        TickingEntry entry = Neruina.getInstance().getTickHandler().getTickingEntry(id);
        if (entry == null) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.info.not_found", id.toString()));
            return 0;
        }
        Object cause = entry.getCause();
        if (cause == null) {
            NeruinaCommandHandler.sendFeedback(context, VersionedText.pad(VersionedText.concatDelimited(VersionedText.LINE_BREAK, VersionedText.format(VersionedText.translatable("commands.neruina.info.null_cause", entry.getCauseName(), messageHandler.posAsNums(entry.pos()))), messageHandler.generateTeleportAction(ErroredType.UNKNOWN, entry.dimension(), entry.pos()), messageHandler.generateResourceActions(entry))));
        } else if (cause instanceof Entity) {
            Entity entity = (Entity)cause;
            NeruinaCommandHandler.sendFeedback(context, VersionedText.pad(VersionedText.concatDelimited(VersionedText.LINE_BREAK, VersionedText.format(VersionedText.translatable("commands.neruina.info.entity", entry.getCauseName(), messageHandler.posAsNums(entry.pos()))), messageHandler.generateEntityActions(entity), messageHandler.generateResourceActions(entry))));
        } else if (cause instanceof BlockEntity) {
            NeruinaCommandHandler.sendFeedback(context, VersionedText.pad(VersionedText.concatDelimited(VersionedText.LINE_BREAK, VersionedText.format(VersionedText.translatable("commands.neruina.info.block_entity", entry.getCauseName(), messageHandler.posAsNums(entry.pos()))), messageHandler.generateHandlingActions(ErroredType.BLOCK_ENTITY, entry.dimension(), entry.pos()), messageHandler.generateResourceActions(entry))));
        } else if (cause instanceof ItemStack) {
            NeruinaCommandHandler.sendFeedback(context, VersionedText.pad(VersionedText.concatDelimited(VersionedText.LINE_BREAK, VersionedText.format(VersionedText.translatable("commands.neruina.info.item_stack", entry.getCauseName())), messageHandler.generateResumeAction(ErroredType.ITEM_STACK, entry.uuid().toString()), messageHandler.generateResourceActions(entry))));
        } else {
            NeruinaCommandHandler.sendFeedback(context, VersionedText.pad(VersionedText.concatDelimited(VersionedText.LINE_BREAK, VersionedText.format(VersionedText.translatable("commands.neruina.info.unknown", entry.getCauseName())), messageHandler.generateResourceActions(entry))));
        }
        return 1;
    }

    private static int executeClear(CommandContext<CommandSourceStack> context) {
        int count = Neruina.getInstance().getTickHandler().clearTracked();
        if (count == 0) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.clear.none", new Object[0]));
            return 0;
        }
        NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.clear", count));
        return 1;
    }

    private static int executeShowSuspended(CommandContext<CommandSourceStack> context) {
        int count = Neruina.getInstance().getTickHandler().getTickingEntries().size();
        if (count == 0) {
            ((CommandSourceStack)context.getSource()).m_81352_(messageHandler.formatText("commands.neruina.show_suspended.none", new Object[0]));
            return 0;
        }
        Component message = messageHandler.generateSuspendedInfo();
        NeruinaCommandHandler.sendFeedback(context, message);
        return 1;
    }

    private static void sendFeedback(CommandContext<CommandSourceStack> context, Component text) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> text, true);
    }
}

