/*
 * Decompiled with CFR 0.152.
 */
package fuzs.nightconfigfixes.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.utils.UnmodifiableConfigWrapper;
import com.google.common.base.Joiner;
import fuzs.nightconfigfixes.config.CheckedConfigFileTypeHandler;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ConfigSpecWrapper
extends UnmodifiableConfigWrapper<ForgeConfigSpec>
implements IConfigSpec<ConfigSpecWrapper> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private boolean isCorrecting;

    public ConfigSpecWrapper(ForgeConfigSpec config) {
        super((UnmodifiableConfig)config);
    }

    public ForgeConfigSpec getSpec() {
        return (ForgeConfigSpec)this.config;
    }

    public void acceptConfig(CommentedConfig data) {
        ObfuscationReflectionHelper.setPrivateValue(ForgeConfigSpec.class, (Object)((ForgeConfigSpec)this.config), (Object)data, (String)"childConfig");
        if (data != null && !this.isCorrect(data)) {
            String configName = data instanceof FileConfig ? ((FileConfig)data).getNioPath().toString() : data.toString();
            LOGGER.warn(Logging.CORE, "Configuration file {} is not correct. Correcting", (Object)configName);
            this.correct(data);
            if (data instanceof FileConfig) {
                ((FileConfig)data).save();
            }
        }
        this.afterReload();
    }

    public boolean isCorrecting() {
        return this.isCorrecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCorrect(CommentedConfig commentedFileConfig) {
        ConfigSpecWrapper configSpecWrapper = this;
        synchronized (configSpecWrapper) {
            LinkedList<String> parentPath = new LinkedList<String>();
            return this.correct(this.config, commentedFileConfig, null, parentPath, Collections.unmodifiableList(parentPath), (a, b, c, d) -> {}, (action, path, incorrectValue, correctedValue) -> {}, true) == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int correct(CommentedConfig config) {
        int ret;
        LinkedList<String> parentPath = new LinkedList<String>();
        try {
            Map<String, Object> defaultMap;
            this.isCorrecting = true;
            if (config instanceof FileConfig) {
                FileConfig fileConfig = (FileConfig)config;
                defaultMap = CheckedConfigFileTypeHandler.DEFAULT_CONFIG_VALUES.get(fileConfig.getNioPath().getFileName().toString().intern());
            } else {
                defaultMap = null;
            }
            ret = this.correct(this.config, config, defaultMap, parentPath, Collections.unmodifiableList(parentPath), (action, path, incorrectValue, correctedValue) -> LOGGER.warn(Logging.CORE, "Incorrect key {} was corrected from {} to its default, {}. {}", (Object)DOT_JOINER.join((Iterable)path), incorrectValue, correctedValue, (Object)(incorrectValue == correctedValue ? "This seems to be an error." : "")), (action, path, incorrectValue, correctedValue) -> LOGGER.debug(Logging.CORE, "The comment on key {} does not match the spec. This may create a backup.", (Object)DOT_JOINER.join((Iterable)path)), false);
        }
        finally {
            this.isCorrecting = false;
        }
        return ret;
    }

    public void afterReload() {
        ((ForgeConfigSpec)this.config).afterReload();
    }

    private int correct(UnmodifiableConfig spec, CommentedConfig config, @Nullable Map<String, Object> defaultMap, LinkedList<String> parentPath, List<String> parentPathUnmodifiable, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener, boolean dryRun) {
        int count = 0;
        Map specMap = spec.valueMap();
        Map configMap = config.valueMap();
        for (Map.Entry specEntry : specMap.entrySet()) {
            String key = (String)specEntry.getKey();
            Object specValue = specEntry.getValue();
            Object configValue = configMap.get(key);
            ConfigSpec.CorrectionAction action = configValue == null ? ConfigSpec.CorrectionAction.ADD : ConfigSpec.CorrectionAction.REPLACE;
            parentPath.addLast(key);
            if (specValue instanceof Config) {
                if (configValue instanceof CommentedConfig) {
                    Map map;
                    Object object;
                    Config config2 = (Config)specValue;
                    CommentedConfig commentedConfig = (CommentedConfig)configValue;
                    if (defaultMap != null && (object = defaultMap.get(key)) instanceof Config) {
                        Config defaultConfig = (Config)object;
                        map = defaultConfig.valueMap();
                    } else {
                        map = null;
                    }
                    if ((count += this.correct((UnmodifiableConfig)config2, commentedConfig, map, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun)) > 0 && dryRun) {
                        return count;
                    }
                } else {
                    Map map;
                    Object object;
                    if (dryRun) {
                        return 1;
                    }
                    CommentedConfig newValue = config.createSubConfig();
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, (Object)newValue);
                    ++count;
                    Config config3 = (Config)specValue;
                    if (defaultMap != null && (object = defaultMap.get(key)) instanceof Config) {
                        Config defaultConfig = (Config)object;
                        map = defaultConfig.valueMap();
                    } else {
                        map = null;
                    }
                    count += this.correct((UnmodifiableConfig)config3, newValue, map, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun);
                }
                String newComment = ((ForgeConfigSpec)this.config).getLevelComment(parentPath);
                oldComment = config.getComment(key);
                if (!this.stringsMatchIgnoringNewlines(oldComment, newComment)) {
                    commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)newComment);
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, newComment);
                }
            } else {
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)specValue;
                if (!valueSpec.test(configValue)) {
                    Object newValue;
                    if (dryRun) {
                        return 1;
                    }
                    if (defaultMap != null && defaultMap.containsKey(key)) {
                        newValue = defaultMap.get(key);
                        if (!valueSpec.test(newValue)) {
                            newValue = valueSpec.correct(configValue);
                        }
                    } else {
                        newValue = valueSpec.correct(configValue);
                    }
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    ++count;
                }
                if (!this.stringsMatchIgnoringNewlines(oldComment = config.getComment(key), valueSpec.getComment())) {
                    commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)valueSpec.getComment());
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, valueSpec.getComment());
                }
            }
            parentPath.removeLast();
        }
        Iterator ittr = configMap.entrySet().iterator();
        while (ittr.hasNext()) {
            Map.Entry entry = ittr.next();
            if (specMap.containsKey(entry.getKey())) continue;
            if (dryRun) {
                return 1;
            }
            ittr.remove();
            parentPath.addLast((String)entry.getKey());
            listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, entry.getValue(), null);
            parentPath.removeLast();
            ++count;
        }
        return count;
    }

    private boolean stringsMatchIgnoringNewlines(@Nullable Object obj1, @Nullable Object obj2) {
        if (obj1 instanceof String) {
            String string1 = (String)obj1;
            if (obj2 instanceof String) {
                String string2 = (String)obj2;
                if (string1.length() > 0 && string2.length() > 0) {
                    return string1.replaceAll("\r\n", "\n").equals(string2.replaceAll("\r\n", "\n"));
                }
            }
        }
        return Objects.equals(obj1, obj2);
    }
}

