/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock.SharpenedRockStructure;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;

public class SharpenedRockPiece
extends StructurePiece {
    private final BlockPos origin;
    private final int radius;
    private final boolean hasFoundation;
    private final boolean hasSpike;
    private final double pitch;
    private final double yaw;
    private final int[] cache;

    public SharpenedRockPiece(BlockPos origin, int radius, boolean hasFoundation, boolean hasSpike, double pitch, double yaw, int[] cache, int genDepth, BoundingBox box) {
        super(BWGStructurePieceTypes.SHARPENED_ROCK_PIECE.get(), genDepth, box);
        this.origin = origin;
        this.radius = radius;
        this.hasFoundation = hasFoundation;
        this.hasSpike = hasSpike;
        this.pitch = pitch;
        this.yaw = yaw;
        this.cache = cache;
    }

    public SharpenedRockPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BWGStructurePieceTypes.SHARPENED_ROCK_PIECE.get(), tag);
        this.origin = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("origin"));
        this.radius = tag.m_128451_("radius");
        this.hasFoundation = tag.m_128471_("foundation");
        this.hasSpike = tag.m_128471_("spike");
        this.pitch = tag.m_128459_("pitch");
        this.yaw = tag.m_128459_("yaw");
        this.cache = tag.m_128465_("height_cache");
    }

    protected void m_183620_(@NotNull StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        compoundTag.m_128365_("origin", (Tag)NbtUtils.m_129224_((BlockPos)this.origin));
        compoundTag.m_128405_("radius", this.radius);
        compoundTag.m_128379_("foundation", this.hasFoundation);
        compoundTag.m_128379_("spike", this.hasSpike);
        compoundTag.m_128347_("pitch", this.pitch);
        compoundTag.m_128347_("yaw", this.yaw);
        compoundTag.m_128385_("height_cache", this.cache);
    }

    public void m_213694_(WorldGenLevel worldGenLevel, @NotNull StructureManager structureManager, @NotNull ChunkGenerator chunkGenerator, @NotNull RandomSource r, @NotNull BoundingBox boundingBox, @NotNull ChunkPos chunkPos, @NotNull BlockPos blockPos) {
        RandomSource randomSource = RandomSource.m_216335_((long)(worldGenLevel.m_6018_().m_7654_().m_129910_().m_246337_().m_245499_() + this.origin.m_121878_()));
        WeightedStateProvider blocks = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50287_.m_49966_(), 10).m_146271_((Object)Blocks.f_50295_.m_49966_(), 1).m_146270_());
        LongOpenHashSet placed = new LongOpenHashSet();
        Quaterniond quaternion = new Quaterniond();
        quaternion.rotateY(Math.toRadians(this.yaw));
        quaternion.rotateX(Math.toRadians(this.pitch));
        BlockState[] bandStates = new BlockState[]{Blocks.f_50287_.m_49966_(), Blocks.f_50295_.m_49966_(), Blocks.f_50287_.m_49966_(), Blocks.f_50295_.m_49966_(), Blocks.f_50287_.m_49966_()};
        BlockState[] bands = new BlockState[25];
        int i = 0;
        while (i < bands.length) {
            BlockState selectedState = bandStates[randomSource.m_188503_(bandStates.length)];
            int fillerSize = randomSource.m_216339_(1, 5);
            for (int filler = 0; filler < fillerSize && i < bands.length; ++i, ++filler) {
                bands[i] = selectedState;
            }
        }
        if (this.hasSpike) {
            SharpenedRockStructure.generateFromCache(this.radius, this.cache, this.origin, quaternion, false, (arg_0, arg_1) -> this.lambda$postProcess$0((LongSet)placed, bands, worldGenLevel, arg_0, arg_1));
        }
        if (this.hasFoundation) {
            SharpenedRockStructure.generateFromCache(this.radius, this.cache, this.origin, quaternion, true, (arg_0, arg_1) -> this.lambda$postProcess$1((LongSet)placed, bands, worldGenLevel, arg_0, arg_1));
        }
    }

    private /* synthetic */ boolean lambda$postProcess$1(LongSet placed, BlockState[] bands, WorldGenLevel worldGenLevel, BlockPos rotatedPos, BlockPos unRotatedPos) {
        if (this.f_73383_.m_71051_((Vec3i)rotatedPos) && placed.add(rotatedPos.m_121878_())) {
            BlockState state = bands[unRotatedPos.m_123342_() % (bands.length - 1)];
            worldGenLevel.m_7731_(rotatedPos, state, 2);
            return true;
        }
        return true;
    }

    private /* synthetic */ boolean lambda$postProcess$0(LongSet placed, BlockState[] bands, WorldGenLevel worldGenLevel, BlockPos rotatedPos, BlockPos unRotatedPos) {
        if (this.f_73383_.m_71051_((Vec3i)rotatedPos) && placed.add(rotatedPos.m_121878_())) {
            BlockState state = bands[unRotatedPos.m_123342_() % (bands.length - 1)];
            worldGenLevel.m_7731_(rotatedPos, state, 2);
        }
        return true;
    }
}

