/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.CheckedBlockPlacement;

public class PillarFeature
extends Feature<Config> {
    public PillarFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        Config config = (Config)context.m_159778_();
        int height = config.height.m_214085_(random);
        int radius = config.radius.m_214085_(random);
        double frequency = config.noisefreq.m_214084_(random);
        double minRadiusScale = config.minRadiusScale.m_214084_(random);
        DistanceTestType tester = (DistanceTestType)((Object)config.distanceTestType.m_216820_(random).orElseThrow());
        ImprovedNoise noise = new ImprovedNoise(random);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        LongOpenHashSet cache = new LongOpenHashSet();
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                mutableBlockPos.m_122154_((Vec3i)origin, xOffset, 0, zOffset);
                if (!tester.distanceTester.withinDistance(origin, (BlockPos)mutableBlockPos, radius)) continue;
                int heightmap = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_());
                int radius1 = radius;
                int maxY = origin.m_123342_() + height;
                for (int worldY = heightmap - 5; worldY <= maxY; ++worldY) {
                    mutableBlockPos.m_122178_(origin.m_123341_() + xOffset, worldY, origin.m_123343_() + zOffset);
                    double pillarNoise = (noise.m_164308_((double)mutableBlockPos.m_123341_() * frequency, (double)mutableBlockPos.m_123342_() * frequency, (double)mutableBlockPos.m_123343_() * frequency) + 1.0) * 0.5;
                    double localRadius = Mth.m_14085_((double)((double)radius1 * minRadiusScale), (double)radius1, (double)pillarNoise);
                    if (!tester.distanceTester.withinDistance(origin.m_175288_(worldY), (BlockPos)mutableBlockPos, localRadius)) continue;
                    cache.add(mutableBlockPos.m_121878_());
                }
            }
        }
        for (Pair<BlockPredicate, BlockStateProvider> blockPlacement : config.checkedBlockPlacement.blockPlacement()) {
            cache.forEach(pos -> {
                mutableBlockPos.m_122188_(pos);
                if (((BlockPredicate)blockPlacement.getFirst()).test((Object)level, (Object)mutableBlockPos)) {
                    level.m_7731_((BlockPos)mutableBlockPos, ((BlockStateProvider)blockPlacement.getSecond()).m_213972_(random, (BlockPos)mutableBlockPos), 2);
                }
            });
        }
        UniformInt vineLengthSampler = UniformInt.m_146622_((int)1, (int)10);
        int vineLength = vineLengthSampler.m_214085_(random);
        cache.forEach(arg_0 -> PillarFeature.lambda$place$1(mutableBlockPos, random, vineLength, level, (LongSet)cache, arg_0));
        return true;
    }

    private static /* synthetic */ void lambda$place$1(BlockPos.MutableBlockPos mutableBlockPos, RandomSource random, int vineLength, WorldGenLevel level, LongSet cache, long pos) {
        mutableBlockPos.m_122188_(pos);
        Direction.Plane horizontal = Direction.Plane.HORIZONTAL;
        for (Direction direction : horizontal) {
            if (!(random.m_188500_() < 0.1)) continue;
            mutableBlockPos.m_122188_(pos).m_122173_(direction);
            for (int i = 0; i < vineLength; ++i) {
                if (level.m_8055_((BlockPos)mutableBlockPos).m_60795_() && !cache.contains(mutableBlockPos.m_121878_())) {
                    level.m_7731_((BlockPos)mutableBlockPos, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.m_57883_((Direction)direction.m_122424_()), (Comparable)Boolean.valueOf(true)), 2);
                }
                mutableBlockPos.m_122173_(Direction.DOWN);
            }
        }
    }

    public record Config(CheckedBlockPlacement checkedBlockPlacement, IntProvider height, IntProvider radius, FloatProvider noisefreq, FloatProvider minRadiusScale, SimpleWeightedRandomList<DistanceTestType> distanceTestType) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CheckedBlockPlacement.CODEC.fieldOf("block_placement").forGetter(Config::checkedBlockPlacement), (App)IntProvider.f_146531_.fieldOf("height").forGetter(Config::height), (App)IntProvider.f_146531_.fieldOf("radius").forGetter(Config::radius), (App)FloatProvider.f_146502_.fieldOf("noise_frequency").forGetter(Config::noisefreq), (App)FloatProvider.f_146502_.fieldOf("min_radius_scale").forGetter(Config::minRadiusScale), (App)SimpleWeightedRandomList.m_146264_(DistanceTestType.CODEC).fieldOf("distance_test_type").forGetter(Config::distanceTestType)).apply((Applicative)instance, Config::new));
    }

    public static enum DistanceTestType {
        EUCLIDEAN(Vec3i::m_123314_),
        MANHATTAN((origin, from, radius) -> (double)origin.m_123333_((Vec3i)from) < radius),
        CHEBYSHEV((origin, from, radius) -> {
            int dx = Math.abs(origin.m_123341_() - from.m_123341_());
            int dy = Math.abs(origin.m_123342_() - from.m_123342_());
            int dz = Math.abs(origin.m_123343_() - from.m_123343_());
            return (double)Math.max(Math.max(dx, dy), dz) < radius;
        });

        public static final Codec<DistanceTestType> CODEC;
        private final DistanceTester distanceTester;

        private DistanceTestType(DistanceTester distanceTester) {
            this.distanceTester = distanceTester;
        }

        public DistanceTester getDistanceTester() {
            return this.distanceTester;
        }

        static {
            CODEC = Codec.STRING.xmap(DistanceTestType::valueOf, Enum::name);
        }
    }

    @FunctionalInterface
    public static interface DistanceTester {
        public boolean withinDistance(BlockPos var1, BlockPos var2, double var3);
    }
}

