/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.serializer;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.christofmeg.justenoughbreeding.utils.Utils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class BreedingSerializer
implements RecipeSerializer<BreedingRecipe> {
    @NotNull
    public BreedingRecipe fromJson(@NotNull ResourceLocation jsonPath, @NotNull JsonObject json) {
        return (BreedingRecipe)Utils.readJsonContents(jsonPath, json, "breeding");
    }

    @NotNull
    public BreedingRecipe fromNetwork(@NotNull ResourceLocation resourceLocation, @NotNull FriendlyByteBuf buf) {
        ResourceLocation entityRL = buf.m_130281_();
        EntityType<?> entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(entityRL);
        if (entityType == null) {
            throw new JsonParseException("Unknown EntityType in BreedingRecipe#fromNetwork: " + entityRL);
        }
        Ingredient inputStack = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Ingredient spawnEgg = Ingredient.m_43940_((FriendlyByteBuf)buf);
        boolean hasResult = buf.readBoolean();
        Ingredient resultItemStack = hasResult ? Ingredient.m_43940_((FriendlyByteBuf)buf) : Ingredient.f_43901_;
        boolean hasExtra = buf.readBoolean();
        Ingredient extraInputStack = hasExtra ? Ingredient.m_43940_((FriendlyByteBuf)buf) : Ingredient.f_43901_;
        Boolean needsToBeTamed = buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null;
        Boolean animalTrusting = buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null;
        String jsonModID = buf.m_130277_();
        String jsonAnimalID = buf.m_130277_();
        String modFolder = buf.m_130277_();
        String fileName = buf.m_130277_();
        return new BreedingRecipe(entityType, inputStack, spawnEgg, needsToBeTamed, resultItemStack, extraInputStack, animalTrusting, jsonModID, jsonAnimalID, modFolder, fileName);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull BreedingRecipe recipe) {
        ResourceLocation entityKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.entityType);
        if (entityKey == null) {
            throw new JsonParseException("Unknown EntityType in BreedingRecipe: " + recipe.entityType);
        }
        buf.m_130085_(entityKey);
        CommonUtils.safe(recipe.inputStack).m_43923_(buf);
        CommonUtils.safe(recipe.spawnEgg).m_43923_(buf);
        boolean hasResult = recipe.resultItemStack != null && !recipe.resultItemStack.m_43947_();
        buf.writeBoolean(hasResult);
        if (hasResult) {
            recipe.resultItemStack.m_43923_(buf);
        }
        boolean hasExtra = recipe.extraInputStack != null && !recipe.extraInputStack.m_43947_();
        buf.writeBoolean(hasExtra);
        if (hasExtra) {
            recipe.extraInputStack.m_43923_(buf);
        }
        if (recipe.needsToBeTamed != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(recipe.needsToBeTamed.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        if (recipe.animalTrusting != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(recipe.animalTrusting.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130070_(recipe.jsonModID);
        buf.m_130070_(recipe.jsonAnimalID);
        buf.m_130070_(recipe.modFolder);
        buf.m_130070_(recipe.fileName);
    }
}

