/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.caverns_and_chasms.common.entity.animal.Rat;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RatModel<T extends Rat>
extends AgeableListModel<T> {
    public ModelPart head;
    public ModelPart body;
    public ModelPart tail;
    public ModelPart leftFrontLeg;
    public ModelPart leftHindLeg;
    public ModelPart rightFrontLeg;
    public ModelPart rightHindLeg;

    public RatModel(ModelPart root) {
        super(false, 5.0f, 2.0f);
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.tail = root.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-1.5f, -2.0f, -6.0f, 3.0f, 3.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)21.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-3.0f, -1.0f, 0.5f, 2.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171480_().m_171481_(1.0f, -1.0f, 0.5f, 2.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("whisker", CubeListBuilder.m_171558_().m_171514_(12, 14).m_171481_(-3.5f, -2.0f, -4.0f, 7.0f, 3.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("tooth", CubeListBuilder.m_171558_().m_171514_(4, 0).m_171481_(-0.5f, 1.0f, -5.0f, 1.0f, 1.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -3.0f, 0.0f, 5.0f, 5.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)21.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)23.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)23.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)23.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)23.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(12, 5).m_171481_(0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)21.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.tail);
    }

    public void renderOnShoulder(PoseStack matrixStackIn, VertexConsumer vertexconsumer, int packedLightIn, int overlayTexture, float tailWagAmount, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupAnim(State.ON_SHOULDER, tailWagAmount, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, overlayTexture, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void setupAnim(T rat, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupAnim(rat.m_21825_() ? State.SITTING : State.STANDING, ((Rat)((Object)rat)).getTailWagAmount(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void setupAnim(State state, float tailWagAmount, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        switch (state) {
            case STANDING: {
                this.head.m_104227_(0.0f, !this.f_102610_ ? 21.0f : 17.5f, -3.0f);
                this.body.m_104227_(0.0f, 21.0f, -3.0f);
                this.body.f_104203_ = 0.0f;
                this.rightHindLeg.m_104227_(-2.0f, 23.0f, 4.0f);
                this.leftHindLeg.m_104227_(2.0f, 23.0f, 4.0f);
                this.rightFrontLeg.m_104227_(-2.0f, 23.0f, -1.0f);
                this.leftFrontLeg.m_104227_(2.0f, 23.0f, -1.0f);
                this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
                this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
                this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                this.tail.m_104227_(0.0f, 21.0f, 5.0f);
                this.tail.f_104203_ = 0.0f;
                break;
            }
            case SITTING: {
                this.head.m_104227_(0.0f, !this.f_102610_ ? 15.0f : 14.0f, !this.f_102610_ ? 0.5f : -1.5f);
                this.body.m_104227_(0.0f, 16.0f, -0.5f);
                this.body.f_104203_ = -1.5707964f;
                this.rightHindLeg.m_104227_(-2.0f, 24.0f, -3.0f);
                this.leftHindLeg.m_104227_(2.0f, 24.0f, -3.0f);
                this.rightFrontLeg.m_104227_(-2.0f, 19.0f, -2.5f);
                this.leftFrontLeg.m_104227_(2.0f, 19.0f, -2.5f);
                this.rightHindLeg.f_104203_ = -1.5707964f;
                this.leftHindLeg.f_104203_ = -1.5707964f;
                this.rightFrontLeg.f_104203_ = -0.7853982f;
                this.leftFrontLeg.f_104203_ = -0.7853982f;
                this.tail.m_104227_(0.0f, 23.0f, 2.5f);
                this.tail.f_104203_ = 0.0f;
                break;
            }
            case ON_SHOULDER: {
                this.head.m_104227_(0.0f, !this.f_102610_ ? 21.0f : 17.5f, -3.0f);
                this.body.m_104227_(0.0f, 21.0f, -3.0f);
                this.body.f_104203_ = 0.0f;
                this.rightHindLeg.m_104227_(-1.0f, 23.0f, 3.0f);
                this.leftHindLeg.m_104227_(1.0f, 23.0f, 3.0f);
                this.rightFrontLeg.m_104227_(-1.0f, 23.0f, 0.0f);
                this.leftFrontLeg.m_104227_(1.0f, 23.0f, 0.0f);
                this.rightHindLeg.f_104203_ = 0.0f;
                this.leftHindLeg.f_104203_ = 0.0f;
                this.rightFrontLeg.f_104203_ = 0.0f;
                this.leftFrontLeg.f_104203_ = 0.0f;
                this.tail.m_104227_(0.0f, 21.0f, 5.0f);
                this.tail.f_104203_ = -1.0f;
            }
        }
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.tail.f_104204_ = -tailWagAmount * 0.45f * Mth.m_14031_((float)(0.6f * ageInTicks));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum State {
        STANDING,
        SITTING,
        ON_SHOULDER;

    }
}

