/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.levelgen.feature.LaurelTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class LargeLaurelTreeFeature
extends LaurelTreeFeature {
    public LargeLaurelTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    @Override
    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        boolean shortTrunk = false;
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < 2; ++k) {
                int trunkHeight = LargeLaurelTreeFeature.getStumpHeight(config, random);
                if (trunkHeight == 2) {
                    if (!shortTrunk) {
                        shortTrunk = true;
                    } else {
                        while (trunkHeight == 2) {
                            trunkHeight = LargeLaurelTreeFeature.getStumpHeight(config, random);
                        }
                    }
                }
                for (int j = 0; j < trunkHeight; ++j) {
                    this.addLog(origin.m_7918_(i, j, k));
                }
            }
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean positive = direction.m_122421_() == Direction.AxisDirection.POSITIVE;
            boolean xAxis = direction.m_122434_() == Direction.Axis.X;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            this.addRoots(context, direction, pos);
            pos.m_122190_((Vec3i)origin.m_7918_(xAxis ? (positive ? 1 : 0) : random.m_188503_(2), 0, !xAxis ? (positive ? 1 : 0) : random.m_188503_(2)));
            int height = 0;
            while (this.logPositions.contains(pos.m_6630_(height))) {
                ++height;
            }
            pos.m_122190_((Vec3i)pos.m_6630_(height - 1));
            if (height <= 2) continue;
            this.createBranch((BlockPos)pos, direction, random, 3, this.getMaxLength(), this.getMaxHeight());
        }
    }

    public int getMaxLength() {
        return 4;
    }

    public int getMaxHeight() {
        return 3;
    }

    public void addRoots(FeaturePlaceContext<TreeConfiguration> context, Direction direction, BlockPos.MutableBlockPos pos) {
    }

    private static int getStumpHeight(TreeConfiguration config, RandomSource random) {
        return config.f_68190_.m_226153_(random) - 1 + random.m_188503_(2);
    }

    private void createBranch(BlockPos pos, Direction direction, RandomSource random, int minLength, int maxLength, int maxHeight) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)pos);
        int length = minLength;
        if (random.m_188503_(3) == 0) {
            length = maxLength;
        }
        int height = 0;
        boolean bonus = false;
        for (int i = 0; i < length; ++i) {
            mutablePos.m_122190_((Vec3i)mutablePos.m_121945_(direction));
            if (random.m_188503_(2) == 0 && height < maxHeight) {
                mutablePos.m_122190_((Vec3i)mutablePos.m_7494_());
                ++height;
            }
            this.addLog((BlockPos)mutablePos);
            int smallMaxSize = this.getSmallMaxSize();
            if (i <= 0 || height >= maxHeight - 1 || minLength == 2 || bonus && this.limitBranches() || random.m_188503_(this.getSmallMaxSize()) == 0) continue;
            this.createBranch((BlockPos)mutablePos, random.m_188499_() ? direction.m_122427_() : direction.m_122428_(), random, 2, smallMaxSize, smallMaxSize);
            bonus = true;
        }
        this.createLeafChunk((BlockPos)mutablePos, direction, random);
    }

    public int getSmallMaxSize() {
        return 2;
    }

    public boolean limitBranches() {
        return true;
    }
}

