/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class KousaTreeFeature
extends BlueprintTreeFeature {
    public KousaTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int trunkHeight = config.f_68190_.m_226153_(random);
        for (int y = 0; y < trunkHeight; ++y) {
            this.addLog(origin.m_6630_(y));
        }
        ArrayList branchDirections = Lists.newArrayList();
        Direction.Plane.HORIZONTAL.forEach(branchDirections::add);
        int branches = 2 + random.m_188503_(3) - (random.m_188499_() ? random.m_188503_(2) : 0);
        if (branches < 3) {
            this.addLog(origin.m_6630_(trunkHeight));
            this.createLeafBalloon(origin.m_6630_(trunkHeight));
        }
        if (branches > 1) {
            for (int i = 0; i < branches; ++i) {
                Direction direction = (Direction)branchDirections.get(random.m_188503_(branchDirections.size()));
                this.createBranch(origin.m_6630_(trunkHeight), direction, random);
                branchDirections.remove(direction);
            }
        }
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.KOUSA_SAPLING.get()).m_49966_();
    }

    private void createBranch(BlockPos pos, Direction direction, RandomSource random) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)pos.m_7495_());
        for (int i = 0; i < 2; ++i) {
            mutablePos.m_122190_((Vec3i)mutablePos.m_121945_(direction).m_6630_(random.m_188503_(2)));
            this.addLog((BlockPos)mutablePos);
        }
        this.addLog((BlockPos)mutablePos.m_122190_((Vec3i)mutablePos.m_5484_(direction, random.m_188503_(2)).m_7494_()));
        this.createLeafBalloon((BlockPos)mutablePos);
    }

    private void createLeafBalloon(BlockPos pos) {
        int leafSize = 1;
        for (int i = -leafSize; i <= leafSize; ++i) {
            for (int j = -leafSize; j <= leafSize; ++j) {
                for (int k = -leafSize; k <= leafSize; ++k) {
                    this.addFoliage(pos.m_7918_(i, j, k));
                }
            }
        }
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = pos.m_5484_(direction, 2);
            this.addFoliage(offsetPos);
            for (Direction sideDirection : Direction.values()) {
                if (sideDirection.m_122434_() == direction.m_122434_()) continue;
                this.addFoliage(offsetPos.m_121945_(sideDirection));
            }
        }
    }
}

