/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity;

import com.google.common.collect.Lists;
import com.teamabnormals.atmospheric.common.entity.TetraVariant;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBiomeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericRegistries;
import com.teamabnormals.atmospheric.core.registry.AtmosphericSoundEvents;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class Tetra
extends AbstractSchoolingFish
implements VariantHolder<TetraVariant> {
    public static final String BUCKET_VARIANT_TAG = "TetraVariant";
    private static final EntityDataAccessor<String> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Tetra.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public Tetra(EntityType<? extends Tetra> p_30015_, Level p_30016_) {
        super(p_30015_, p_30016_);
    }

    public Tetra(PlayMessages.SpawnEntity message, Level level) {
        this((EntityType<? extends Tetra>)((EntityType)AtmosphericEntityTypes.TETRA.get()), level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)TetraVariant.NEON.m_135782_().toString());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Variant", this.getStringVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setStringVariant(tag.m_128461_("Variant"));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 2.25));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 2.6, 2.4, EntitySelector.f_20406_::test));
        this.f_21345_.m_25352_(4, (Goal)new TetraSwimGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FollowFlockLeaderGoal((AbstractSchoolingFish)this));
    }

    public String getStringVariant() {
        return !((String)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT)).isEmpty() ? (String)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT) : TetraVariant.NEON.m_135782_().toString();
    }

    private void setStringVariant(String var) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)var);
    }

    public void setVariant(TetraVariant variant) {
        this.setVariant(this.m_9236_().m_9598_().m_175515_(AtmosphericRegistries.TETRA_VARIANT).m_7981_((Object)variant));
    }

    public TetraVariant getVariant() {
        return (TetraVariant)this.m_9236_().m_9598_().m_175515_(AtmosphericRegistries.TETRA_VARIANT).m_7745_(new ResourceLocation(this.getStringVariant()));
    }

    public void setVariant(ResourceLocation variant) {
        this.setStringVariant(variant.toString());
    }

    public void m_6872_(ItemStack stack) {
        super.m_6872_(stack);
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(BUCKET_VARIANT_TAG, this.getStringVariant());
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)AtmosphericItems.TETRA_BUCKET.get());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AtmosphericSoundEvents.TETRA_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AtmosphericSoundEvents.TETRA_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_30039_) {
        return (SoundEvent)AtmosphericSoundEvents.TETRA_HURT.get();
    }

    protected SoundEvent m_5699_() {
        return (SoundEvent)AtmosphericSoundEvents.TETRA_FLOP.get();
    }

    public int m_6031_() {
        return 12;
    }

    public int m_5792_() {
        return 12;
    }

    public int getMinSchoolSize() {
        return 6;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_27543_() && this.m_27540_() && !Tetra.tryMergeSchools(this, this.f_27520_)) {
            this.m_27541_();
        }
        if (!this.isSchoolFull() && this.f_19796_.m_188503_(50) == 0) {
            List list = this.m_9236_().m_6443_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0), tetra -> tetra != this && (tetra.m_27542_() && tetra != this.f_27520_ || !this.m_27540_() && !this.m_27543_() && tetra.f_27521_ < tetra.m_6031_() && !tetra.m_27540_()));
            for (Tetra tetra2 : list) {
                if ((this.m_27543_() || this.m_27540_()) && Tetra.tryMergeSchools((AbstractSchoolingFish)(this.m_27540_() ? this.f_27520_ : this), tetra2)) break;
                if (this.m_27540_() || this.m_27543_()) continue;
                this.m_27525_(tetra2);
                break;
            }
        }
    }

    public boolean isSchoolFull() {
        return this.m_27543_() ? this.f_27521_ <= this.getMinSchoolSize() : this.m_27540_() && this.f_27520_.f_27521_ <= this.getMinSchoolSize();
    }

    public static boolean tryMergeSchools(AbstractSchoolingFish from, AbstractSchoolingFish to) {
        if (from.f_27521_ + to.f_27521_ <= to.m_6031_()) {
            List fromFollowers = from.m_9236_().m_6443_(Tetra.class, from.m_20191_().m_82377_(8.0, 8.0, 8.0), t -> t.m_27540_() && t.f_27520_ == from);
            fromFollowers.forEach(follower -> {
                follower.m_27541_();
                follower.m_27525_(to);
            });
            from.m_27525_(to);
            return true;
        }
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        TetraVariant tetraVariant;
        data = super.m_6518_(level, difficulty, spawnType, data, tag);
        if (spawnType == MobSpawnType.BUCKET && tag != null && tag.m_128425_(BUCKET_VARIANT_TAG, 8)) {
            this.setStringVariant(tag.m_128461_(BUCKET_VARIANT_TAG));
            return data;
        }
        RandomSource random = level.m_213780_();
        if (data instanceof TetraGroupData) {
            TetraGroupData tetraData = (TetraGroupData)((Object)data);
            tetraVariant = tetraData.variant;
        } else {
            Registry registry = level.m_9598_().m_175515_(AtmosphericRegistries.TETRA_VARIANT);
            ArrayList weightedVariants = Lists.newArrayList();
            for (TetraVariant variant : registry.m_123024_().toList()) {
                for (int i = 0; i < variant.weight(); ++i) {
                    weightedVariants.add(variant);
                }
            }
            tetraVariant = (TetraVariant)Util.m_214621_((List)weightedVariants, (RandomSource)random);
            data = new TetraGroupData(this, tetraVariant);
        }
        this.setVariant(tetraVariant);
        return data;
    }

    public static boolean checkTetraSpawnRules(EntityType<Tetra> tetra, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource random) {
        return level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_) && WaterAnimal.m_218282_(tetra, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)random);
    }

    static class TetraSwimGoal
    extends RandomStrollGoal {
        private final Tetra fish;

        public TetraSwimGoal(Tetra tetra) {
            super((PathfinderMob)tetra, 1.0, 40, false);
            this.fish = tetra;
        }

        public boolean m_8036_() {
            return this.fish.m_6004_() && super.m_8036_();
        }

        @Nullable
        protected Vec3 m_7037_() {
            return TetraSwimGoal.getRandomSwimmablePos(this.f_25725_, 10, 7);
        }

        @Nullable
        public static Vec3 getRandomSwimmablePos(PathfinderMob mob, int xz, int y) {
            Vec3 vec3 = TetraSwimGoal.getPos(mob, xz, y);
            int i = 0;
            while (vec3 != null && !mob.m_9236_().m_8055_(BlockPos.m_274446_((Position)vec3)).m_60647_((BlockGetter)mob.m_9236_(), BlockPos.m_274446_((Position)vec3), PathComputationType.WATER) && i++ < 10) {
                vec3 = TetraSwimGoal.getPos(mob, xz, y);
            }
            return vec3;
        }

        @Nullable
        public static Vec3 getPos(PathfinderMob tetra, int xz, int y) {
            Vec3 vec3 = DefaultRandomPos.m_148403_((PathfinderMob)tetra, (int)xz, (int)y);
            if (vec3 != null) {
                boolean wrongBiome;
                Level level = tetra.m_9236_();
                RandomSource random = tetra.m_217043_();
                BlockPos pos = tetra.m_20097_();
                BlockPos newPos = BlockPos.m_274446_((Position)vec3);
                Holder oldBiome = level.m_204166_(pos);
                Holder newBiome = level.m_204166_(newPos);
                int newLight = level.m_45524_(newPos, 0);
                boolean tooBright = newLight > 5 && random.m_188501_() < (float)newLight / 16.0f;
                boolean bl = wrongBiome = oldBiome.m_203656_(AtmosphericBiomeTags.IS_RAINFOREST) && !newBiome.m_203656_(AtmosphericBiomeTags.IS_RAINFOREST) && random.m_188501_() < 0.95f;
                if (tooBright || wrongBiome) {
                    return TetraSwimGoal.getPos(tetra, xz, y);
                }
            }
            return vec3;
        }
    }

    static class TetraGroupData
    extends AbstractSchoolingFish.SchoolSpawnGroupData {
        final TetraVariant variant;

        TetraGroupData(Tetra leader, TetraVariant variant) {
            super((AbstractSchoolingFish)leader);
            this.variant = variant;
        }
    }

    static class TetraFollowFlockLeader
    extends FollowFlockLeaderGoal {
        public TetraFollowFlockLeader(AbstractSchoolingFish fish) {
            super(fish);
        }
    }
}

