/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.block.CurrantLeavesBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.Tags;

public class CurrantStalkBundleBlock
extends RotatedPillarBlock {
    public CurrantStalkBundleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (!level.m_5776_()) {
            level.m_46961_(pos, true);
            CurrantStalkBundleBlock.breakLeaves((LevelAccessor)level, pos);
            this.breakStalks(state, level, pos);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.m_5776_()) {
            CurrantStalkBundleBlock.breakLeaves((LevelAccessor)level, pos);
            this.breakStalks(state, (Level)level, pos);
            level.m_46961_(pos, true);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.m_21205_().m_204117_(Tags.Items.SHEARS) || EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_()) != 0 || player.m_7500_()) {
            this.m_5707_(level, pos, state, player);
            level.m_7731_(pos, fluid.m_76188_(), level.f_46443_ ? 11 : 3);
            if (!player.m_7500_()) {
                CurrantStalkBundleBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            CurrantStalkBundleBlock.breakLeaves(level, pos);
            this.breakStalks(state, (Level)level, pos);
        }
        super.m_6786_(level, pos, state);
    }

    public static void breakLeaves(LevelAccessor level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = pos.m_121945_(direction);
            BlockState offsetState = level.m_8055_(offsetPos);
            Block block = offsetState.m_60734_();
            if (!(block instanceof CurrantLeavesBlock)) continue;
            CurrantLeavesBlock currantLeaves = (CurrantLeavesBlock)block;
            level.m_186460_(offsetPos, (Block)currantLeaves, 2 + level.m_213780_().m_188503_(2));
        }
    }

    public void breakStalks(BlockState state, Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.isValidDirection(state, direction)) continue;
            BlockPos offsetPos = pos.m_121945_(direction);
            BlockState offsetState = level.m_8055_(offsetPos);
            level.m_186460_(offsetPos, offsetState.m_60734_(), 2 + level.m_213780_().m_188503_(2));
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean isValidDirection(BlockState state, Direction direction) {
        return true;
    }
}

