/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.processors;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.modinit.IAProcessors;
import com.craisinlord.integrated_api.utils.PlatformHooks;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class IntegratedBlockReplaceProcessor
extends StructureProcessor {
    public static final Codec<IntegratedBlockReplaceProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)CompoundTag.f_128325_.optionalFieldOf("input_nbt").forGetter(config -> config.inputNbt), (App)Codec.STRING.fieldOf("required_mod").forGetter(config -> config.requiredMod), (App)BuiltInRegistries.f_256975_.m_194605_().optionalFieldOf("output_block").forGetter(config -> config.outputBlock), (App)BuiltInRegistries.f_256975_.m_194605_().listOf().optionalFieldOf("output_blocks", (Object)ImmutableList.of()).forGetter(config -> config.outputBlocks), (App)CompoundTag.f_128325_.optionalFieldOf("output_nbt").forGetter(config -> config.outputNbt), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(config -> Float.valueOf(config.probability)), (App)BuiltInRegistries.f_256975_.m_194605_().optionalFieldOf("otherwise_block").forGetter(config -> config.otherwiseBlock)).apply((Applicative)instance, instance.stable(IntegratedBlockReplaceProcessor::new)));
    private final Block inputBlock;
    private final Optional<CompoundTag> inputNbt;
    private final String requiredMod;
    private final Optional<Block> outputBlock;
    private final List<Block> outputBlocks;
    private final Optional<CompoundTag> outputNbt;
    private final float probability;
    private final Optional<Block> otherwiseBlock;

    private IntegratedBlockReplaceProcessor(Block inputBlock, Optional<CompoundTag> inputNbt, String requiredMod, Optional<Block> outputBlock, List<Block> outputBlocks, Optional<CompoundTag> outputNbt, float probability, Optional<Block> otherwiseBlock) {
        this.inputBlock = inputBlock;
        this.inputNbt = inputNbt;
        this.requiredMod = requiredMod;
        this.outputBlock = outputBlock;
        this.outputBlocks = outputBlocks;
        this.outputNbt = outputNbt;
        this.probability = probability;
        this.otherwiseBlock = otherwiseBlock;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (structureBlockInfoWorld.f_74676_().m_60734_() == this.inputBlock) {
            if (PlatformHooks.isModLoaded(this.requiredMod)) {
                RandomSource random;
                if (this.inputNbt.isPresent()) {
                    CompoundTag requiredNbt = this.inputNbt.get();
                    BlockState actualNbt = structureBlockInfoWorld.f_74676_();
                    if (actualNbt != null || !actualNbt.equals(requiredNbt)) {
                        return structureBlockInfoWorld;
                    }
                }
                if ((random = RandomSource.m_216327_()).m_188501_() < this.probability) {
                    if (this.outputBlock.isPresent()) {
                        return this.createBlockInfo(structureBlockInfoWorld.f_74675_(), this.outputBlock.get().m_49966_(), this.outputNbt, structureBlockInfoWorld.f_74677_());
                    }
                    if (!this.outputBlocks.isEmpty()) {
                        Block selectedBlock = this.outputBlocks.get(random.m_188503_(this.outputBlocks.size()));
                        return this.createBlockInfo(structureBlockInfoWorld.f_74675_(), selectedBlock.m_49966_(), this.outputNbt, structureBlockInfoWorld.f_74677_());
                    }
                    IntegratedAPI.LOGGER.warn("Integrated API: integrated_api:integrated_block_replace_processor in a processor file has no replacement block of any kind.");
                }
            } else if (this.otherwiseBlock.isPresent()) {
                return this.createBlockInfo(structureBlockInfoWorld.f_74675_(), this.otherwiseBlock.get().m_49966_(), this.outputNbt, structureBlockInfoWorld.f_74677_());
            }
        }
        return structureBlockInfoWorld;
    }

    private StructureTemplate.StructureBlockInfo createBlockInfo(BlockPos pos, BlockState state, Optional<CompoundTag> outputNbt, CompoundTag originalNbt) {
        CompoundTag newNbt = outputNbt.map(CompoundTag::m_6426_).orElse(originalNbt);
        return new StructureTemplate.StructureBlockInfo(pos, state, newNbt);
    }

    protected StructureProcessorType<?> m_6953_() {
        return IAProcessors.INTEGRATED_BLOCK_REPLACE_PROCESSOR.get();
    }
}

