/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.lpcamors.optical.COPartialModels;
import net.lpcamors.optical.blocks.hologram_source.HologramSourceBlockEntity;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.config.COConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class HologramSourceRenderer
extends SafeBlockEntityRenderer<HologramSourceBlockEntity> {
    private static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.m_245263_((String)"trident", (String)"inventory");
    private static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.m_245263_((String)"spyglass", (String)"inventory");

    public HologramSourceRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(HologramSourceBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        double radius;
        BlockState state = be.m_58900_();
        if (!be.isActive()) {
            return;
        }
        BeamHelper.BeamProperties beamProperties = be.getOptionalBeamProperties().get();
        Vec3i color = beamProperties.color;
        ms.m_85836_();
        SuperByteBuffer cube = ((SuperByteBuffer)CachedBuffers.partial((PartialModel)COPartialModels.HOLOGRAM_BEAM, (BlockState)state).center()).light(light).color(color.m_123341_(), color.m_123342_(), color.m_123343_(), 255);
        ((SuperByteBuffer)cube.uncenter()).renderInto(ms, buffer.m_6299_(RenderType.m_110466_()));
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)cube.center()).scale(1.1f)).uncenter()).renderInto(ms, buffer.m_6299_(this.getBeamRenderType()));
        ms.m_85849_();
        ItemStack heldItem = be.getItemStack();
        if (!be.isController() || heldItem.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        boolean blockItem = itemRenderer.m_174264_(heldItem, null, null, 0).m_7539_();
        double d = radius = blockItem ? 1.3 : 0.7;
        if (heldItem.m_150930_(Items.f_42713_) || heldItem.m_150930_(Items.f_151059_)) {
            radius *= 0.5;
        }
        Vec3 vec3 = be.getProjectionBox().m_82399_().m_82546_(Vec3.m_82528_((Vec3i)be.m_58899_()));
        ms.m_85836_();
        ((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(vec3)).scale((float)((double)be.getConnectionLength().intValue() * radius));
        BakedModel bakedmodel = itemRenderer.m_174264_(heldItem, be.m_58904_(), null, 0);
        double ticks = 0.05 * (double)((float)be.m_58904_().m_46468_() + partialTicks);
        double yOffset = (double)0.1f * Math.cos(ticks);
        double rot = ticks;
        if (be.hasFixedAngle()) {
            rot = (double)be.getFixedAngle() * Math.PI / 180.0;
            yOffset = 0.0;
        } else if (be.getMode().equals((Object)HologramSourceBlockEntity.Mode.ROTATING_CLOCKWISE)) {
            rot *= -1.0;
        }
        float normalAlpha = COConfigs.client().hologramDisplay.normalTransparency.getF();
        float additiveAlpha = COConfigs.client().hologramDisplay.additiveTransparency.getF();
        additiveAlpha *= COConfigs.client().hologramDisplay.generalTransparency.getF();
        this.render(beamProperties, itemRenderer, heldItem, ItemDisplayContext.FIXED, false, ms, buffer, 0xF000F0, overlay, bakedmodel, buffer.m_6299_(RenderType.m_110466_()), normalAlpha *= COConfigs.client().hologramDisplay.generalTransparency.getF(), rot, yOffset);
        ms.m_85849_();
        ms.m_85836_();
        ((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(vec3)).scale((float)((double)be.getConnectionLength().intValue() * radius * 1.1));
        BakedModel bakedmodel1 = itemRenderer.m_174264_(heldItem, be.m_58904_(), null, 0);
        this.render(beamProperties, itemRenderer, heldItem, ItemDisplayContext.FIXED, false, ms, buffer, 0xF000F0, overlay, bakedmodel1, buffer.m_6299_(this.getBeamRenderType()), additiveAlpha, rot, yOffset);
        ms.m_85849_();
    }

    public void render(BeamHelper.BeamProperties beamProperties, ItemRenderer renderer, ItemStack itemStack, ItemDisplayContext itemDisplayContext, boolean p_115146_, PoseStack ms, MultiBufferSource buffer, int light, int overlay, BakedModel bakedModel, VertexConsumer vertexConsumer, float alpha, double rotation, double yOffset) {
        if (!itemStack.m_41619_()) {
            boolean flag;
            ms.m_85836_();
            boolean bl = flag = itemDisplayContext == ItemDisplayContext.GUI || itemDisplayContext == ItemDisplayContext.GROUND || itemDisplayContext == ItemDisplayContext.FIXED;
            if (flag) {
                if (itemStack.m_150930_(Items.f_42713_)) {
                    bakedModel = renderer.m_115103_().m_109393_().m_119422_(TRIDENT_MODEL);
                } else if (itemStack.m_150930_(Items.f_151059_)) {
                    bakedModel = renderer.m_115103_().m_109393_().m_119422_(SPYGLASS_MODEL);
                }
            }
            bakedModel = ForgeHooksClient.handleCameraTransforms((PoseStack)ms, (BakedModel)bakedModel, (ItemDisplayContext)itemDisplayContext, (boolean)p_115146_);
            ms.m_252880_(-0.5f, -0.5f, -0.5f);
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(0.0, yOffset, 0.0)).rotateCentered((float)rotation, Direction.UP);
            if (!(bakedModel.m_7521_() || itemStack.m_150930_(Items.f_42713_) && !flag)) {
                Block block;
                boolean flag1 = itemDisplayContext != ItemDisplayContext.GUI && !itemDisplayContext.m_269069_() && itemStack.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)itemStack.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                for (BakedModel model : bakedModel.getRenderPasses(itemStack, flag1)) {
                    this.renderModelLists(beamProperties, renderer, model, itemStack, light, overlay, ms, vertexConsumer, alpha);
                }
            } else {
                IClientItemExtensions.of((ItemStack)itemStack).getCustomRenderer().m_108829_(itemStack, itemDisplayContext, ms, buffer, light, overlay);
            }
            ms.m_85849_();
        }
    }

    public RenderType getBeamRenderType() {
        RenderType.CompositeRenderType renderType = RenderType.m_173215_((String)"create_optical:hologram", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118259_, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172640_)).m_110685_(new RenderStateShard.TransparencyStateShard("hologram_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).m_110661_(new RenderStateShard.CullStateShard(false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110677_(new RenderStateShard.OverlayStateShard(false)).m_110691_(true));
        return renderType;
    }

    public void renderModelLists(BeamHelper.BeamProperties beamProperties, ItemRenderer renderer, BakedModel p_115190_, ItemStack p_115191_, int p_115192_, int p_115193_, PoseStack p_115194_, VertexConsumer p_115195_, float alpha) {
        RandomSource randomsource = RandomSource.m_216327_();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            this.renderQuadList(beamProperties, p_115194_, p_115195_, p_115190_.m_213637_((BlockState)null, direction, randomsource), p_115191_, p_115192_, p_115193_, alpha);
        }
        randomsource.m_188584_(42L);
        this.renderQuadList(beamProperties, p_115194_, p_115195_, p_115190_.m_213637_((BlockState)null, (Direction)null, randomsource), p_115191_, p_115192_, p_115193_, alpha);
    }

    public void renderQuadList(BeamHelper.BeamProperties beamProperties, PoseStack p_115163_, VertexConsumer p_115164_, List<BakedQuad> p_115165_, ItemStack p_115166_, int p_115167_, int p_115168_, float alpha) {
        PoseStack.Pose posestack$pose = p_115163_.m_85850_();
        Vec3i color = beamProperties.color;
        for (BakedQuad bakedquad : p_115165_) {
            p_115164_.putBulkData(posestack$pose, bakedquad, (float)((double)color.m_123341_() / 255.0), (float)((double)color.m_123342_() / 255.0), (float)((double)color.m_123343_() / 255.0), alpha, p_115167_, p_115168_, true);
        }
    }

    public int m_142163_() {
        return 512;
    }
}

