/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import java.util.Iterator;
import net.lpcamors.optical.recipes.FocusingRecipe;
import net.lpcamors.optical.recipes.FocusingRecipeParams;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class SequencedAssemblyFocusingRecipeSerializer
extends ProcessingRecipeSerializer<FocusingRecipe> {
    private static final String INGREDIENT_KEY = "input";
    private static final String REQUIRED_BEAM_TYPE_KEY = "required_beam_type";

    public SequencedAssemblyFocusingRecipeSerializer(ProcessingRecipeBuilder.ProcessingRecipeFactory<FocusingRecipe> factory) {
        super(factory);
    }

    protected Ingredient readIngredient(JsonObject json) {
        if (json.has(INGREDIENT_KEY)) {
            return Ingredient.m_43917_((JsonElement)json.get(INGREDIENT_KEY).getAsJsonObject());
        }
        return Ingredient.f_43901_;
    }

    protected ProcessingOutput readOutput(JsonObject json) {
        Iterator iterator = GsonHelper.m_13933_((JsonObject)json, (String)"results").iterator();
        if (iterator.hasNext()) {
            JsonElement je = (JsonElement)iterator.next();
            return ProcessingOutput.deserialize((JsonElement)je);
        }
        return ProcessingOutput.EMPTY;
    }

    protected FocusingRecipeParams.BeamTypeCondition readRequiredBeamType(JsonObject jsonObject) {
        if (jsonObject.has(REQUIRED_BEAM_TYPE_KEY)) {
            JsonPrimitive j;
            boolean f;
            JsonElement r = jsonObject.get(REQUIRED_BEAM_TYPE_KEY);
            boolean bl = f = r.isJsonPrimitive() && ((JsonPrimitive)r).isNumber();
            if (r instanceof JsonPrimitive && (j = (JsonPrimitive)r).isNumber() && j.getAsInt() >= 0 && j.getAsInt() < FocusingRecipeParams.BeamTypeCondition.values().length) {
                return FocusingRecipeParams.BeamTypeCondition.values()[r.getAsInt()];
            }
        }
        return FocusingRecipeParams.BeamTypeCondition.NONE;
    }

    protected FocusingRecipeParams.BeamTypeCondition readRequiredBeamType(FriendlyByteBuf buffer) {
        int i = buffer.readInt();
        if (i >= 0 && i < FocusingRecipeParams.BeamTypeCondition.values().length) {
            return FocusingRecipeParams.BeamTypeCondition.values()[i];
        }
        return FocusingRecipeParams.BeamTypeCondition.NONE;
    }

    protected void writeToJson(JsonObject json, FocusingRecipe recipe) {
        super.writeToJson(json, (ProcessingRecipe)recipe);
        json.addProperty(REQUIRED_BEAM_TYPE_KEY, (Number)recipe.getRequiredBeamType().getId());
    }

    protected void writeToBuffer(@NotNull FriendlyByteBuf buffer, FocusingRecipe recipe) {
        recipe.getIngredient().m_43923_(buffer);
        recipe.getOutput().write(buffer);
        buffer.writeInt(recipe.getRequiredBeamType().getId());
    }

    @NotNull
    protected FocusingRecipe readFromBuffer(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        return new FocusingRecipe(new FocusingRecipeParams(Ingredient.m_43940_((FriendlyByteBuf)buffer), ProcessingOutput.read((FriendlyByteBuf)buffer), recipeId));
    }

    @NotNull
    protected FocusingRecipe readFromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        return new FocusingRecipe(new FocusingRecipeParams(this.readIngredient(json), this.readOutput(json), recipeId));
    }
}

