/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.compat.jei;

import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.lpcamors.optical.COMod;
import net.lpcamors.optical.CORecipeTypes;
import net.lpcamors.optical.blocks.COBlocks;
import net.lpcamors.optical.blocks.beam_focuser.BeamFocuserBlock;
import net.lpcamors.optical.data.COLang;
import net.lpcamors.optical.recipes.FocusingRecipe;
import net.lpcamors.optical.recipes.FocusingRecipeCategory;
import net.lpcamors.optical.recipes.FocusingRecipeParams;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CreateOpticalJei
implements IModPlugin {
    private static ResourceLocation ID = new ResourceLocation("create_optical", "jei_plugin");
    private List<CreateRecipeCategory<?>> categories = new ArrayList();
    public IIngredientManager ingredientManager;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.categories.clear();
        this.categories.add(this.builder(FocusingRecipe.class).initializeCustomFocusingProcess().addTypedRecipes(CORecipeTypes.FOCUSING::getType).catalystStack(() -> new ItemStack((ItemLike)((BeamFocuserBlock)COBlocks.BEAM_FOCUSER.get()).m_5456_(), 1)).itemIcon((ItemLike)COBlocks.BEAM_FOCUSER).emptyBackground(177, 103).build("focusing", FocusingRecipeCategory::new));
        this.categories.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.categories.forEach(createRecipeCategory -> createRecipeCategory.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.categories.forEach(createRecipeCategory -> createRecipeCategory.registerCatalysts(registration));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    private boolean coloringRecipes(Recipe<?> r) {
        AtomicBoolean b = new AtomicBoolean(false);
        if (r.m_7527_().size() == 2) {
            return Arrays.stream(((Ingredient)r.m_7527_().get(0)).m_43908_()).allMatch(i -> i.m_41720_() instanceof DyeItem) || Arrays.stream(((Ingredient)r.m_7527_().get(1)).m_43908_()).allMatch(i -> i.m_41720_() instanceof DyeItem);
        }
        return b.get();
    }

    private static class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private final Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addTypedRecipesVar(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends Recipe<?>>> recipeType, FocusingRecipeParams.BeamTypeCondition beamTypeCondition) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(t -> {
                Ingredient ingredient = (Ingredient)t.m_7527_().get(0);
                ProcessingOutput p = new ProcessingOutput(t.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()), 1.0f);
                recipes.add(this.createFocusingRecipeOf(ingredient, p, beamTypeCondition, CategoryBuilder.id(t, beamTypeCondition)));
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        static ResourceLocation id(Recipe<?> r, FocusingRecipeParams.BeamTypeCondition beamTypeCondition) {
            return new ResourceLocation("create_optical", r.m_6423_().m_135815_() + "_focusing_" + beamTypeCondition.name().toLowerCase());
        }

        public CategoryBuilder<T> initializeCustomFocusingProcess() {
            Arrays.stream(FocusingRecipeParams.BeamTypeConditionProfile.values()).forEach(beamTypeConditionProfile -> this.addAllRecipesIf(beamTypeConditionProfile.getRecipePredicate(), beamTypeConditionProfile.getConverter(Minecraft.m_91087_().f_91073_.m_9598_())));
            return this;
        }

        public FocusingRecipe createFocusingRecipeOf(Ingredient ingredient, ProcessingOutput processingOutput, FocusingRecipeParams.BeamTypeCondition beamTypeCondition, ResourceLocation id) {
            FocusingRecipe focusingRecipe = new FocusingRecipe(new FocusingRecipeParams(ingredient, processingOutput, id));
            focusingRecipe.beamTypeCondition = beamTypeCondition;
            return focusingRecipe;
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : () -> Collections.emptyList();
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(COMod.loc(name), this.recipeClass), (Component)COLang.Prefixes.JEI.translate(name, new Object[0]), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            return category;
        }
    }
}

