/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.optical_sensor;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.lpcamors.optical.COShapes;
import net.lpcamors.optical.COUtils;
import net.lpcamors.optical.blocks.COBlockEntities;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.IBeamSource;
import net.lpcamors.optical.blocks.optical_sensor.OpticalSensorBlockEntity;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class OpticalSensorBlock
extends DirectionalBlock
implements IWrenchable,
IBeamReceiver,
IBE<OpticalSensorBlockEntity> {
    public static final EnumProperty<Mode> MODE = EnumProperty.m_61587_((String)"sensor_mode", Mode.class);

    public OpticalSensorBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
    }

    public Class<OpticalSensorBlockEntity> getBlockEntityClass() {
        return OpticalSensorBlockEntity.class;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return COShapes.SENSOR.get((Direction)state.m_61143_((Property)f_52588_));
    }

    public BlockEntityType<? extends OpticalSensorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)COBlockEntities.OPTICAL_SENSOR.get();
    }

    public InteractionResult m_6227_(@NotNull BlockState p_60503_, @NotNull Level p_60504_, @NotNull BlockPos p_60505_, @NotNull Player p_60506_, @NotNull InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (p_60506_.m_6144_()) {
            if (p_60504_.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            p_60504_.m_7731_(p_60505_, (BlockState)p_60503_.m_61124_(MODE, (Comparable)((Object)((Mode)((Object)p_60503_.m_61143_(MODE))).getNext())), 3);
            p_60504_.m_46672_(p_60505_, (Block)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void receive(IBeamSource iBeamSource, BlockState state, BlockPos lastPos, BeamHelper.BeamProperties beamProperties, int lastIndex) {
        Direction direction = beamProperties.direction;
        OpticalSensorBlockEntity be = (OpticalSensorBlockEntity)this.getBlockEntity((BlockGetter)iBeamSource.m_58904_(), lastPos);
        if (be == null || ((Direction)state.m_61143_((Property)f_52588_)).equals((Object)direction)) {
            return;
        }
        if (((Mode)((Object)state.m_61143_(MODE))).equals((Object)Mode.DIGITAL) && direction != beamProperties.direction.m_122424_()) {
            IBeamSource.propagateLinearBeamVar(iBeamSource, lastPos, beamProperties, lastIndex);
        }
        if (be.m_58898_() && be.m_58904_().f_46443_) {
            return;
        }
        if (be.changeState(iBeamSource.m_58899_(), beamProperties)) {
            iBeamSource.addDependent(be.m_58899_());
        }
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.m_7926_(p_49915_);
        p_49915_.m_61104_(new Property[]{f_52588_}).m_61104_(new Property[]{MODE}).m_61104_(new Property[]{BlockStateProperties.f_61443_});
    }

    public static int getLight(BlockState state) {
        return ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 1 : 0) * (((Mode)((Object)state.m_61143_(MODE))).equals((Object)Mode.DIGITAL) ? 15 : 10);
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)((BlockState)blockstate.m_61124_(MODE, (Comparable)((Object)Mode.INTENSITY))).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.FALSE);
        }
        return null;
    }

    public boolean m_7898_(@NotNull BlockState p_53186_, @NotNull LevelReader p_53187_, @NotNull BlockPos p_53188_) {
        return OpticalSensorBlock.canAttach(p_53187_, p_53188_, ((Direction)p_53186_.m_61143_((Property)f_52588_)).m_122424_());
    }

    public static boolean canAttach(LevelReader p_53197_, BlockPos p_53198_, Direction p_53199_) {
        BlockPos blockpos = p_53198_.m_121945_(p_53199_);
        return p_53197_.m_8055_(blockpos).m_60783_((BlockGetter)p_53197_, blockpos, p_53199_.m_122424_());
    }

    public boolean m_7899_(@NotNull BlockState p_60571_) {
        return true;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (side != blockState.m_61143_((Property)f_52588_)) {
            return 0;
        }
        return this.m_6378_(blockState, blockAccess, pos, side);
    }

    public int m_6378_(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull Direction direction) {
        return this.getBlockEntityOptional(blockGetter, pos).map(OpticalSensorBlockEntity::getSignal).orElse(0);
    }

    @Override
    public boolean useCenteredIncidence() {
        return true;
    }

    public static enum Mode implements StringRepresentable
    {
        INTENSITY(0, new Vec3i(67, 144, 141), optionalBeamProperties -> optionalBeamProperties.map(beamProperties -> (int)(beamProperties.intensity * 16.0f) - 1).orElse(0)),
        COLOR(1, new Vec3i(136, 162, 255), optionalBeamProperties -> optionalBeamProperties.map(beamProperties -> 15 - (int)(COUtils.getPseudoLengthVec(Vec3.m_82528_((Vec3i)beamProperties.color)) * 0.006535947788506746)).orElse(0)),
        DIGITAL(2, optionalBeamProperties -> optionalBeamProperties.map(beamProperties -> beamProperties.color).orElse(Vec3i.f_123288_), optionalBeamProperties -> optionalBeamProperties.isPresent() ? 1 : 0);

        private final int id;
        private final Function<Optional<BeamHelper.BeamProperties>, Vec3i> color;
        private final Function<Optional<BeamHelper.BeamProperties>, Integer> function;

        private Mode(int id, Vec3i color, Function<Optional<BeamHelper.BeamProperties>, Integer> function) {
            this(id, (Optional<BeamHelper.BeamProperties> optionalBeamProperties) -> color, function);
        }

        private Mode(int id, Function<Optional<BeamHelper.BeamProperties>, Vec3i> color, Function<Optional<BeamHelper.BeamProperties>, Integer> function) {
            this.id = id;
            this.color = color;
            this.function = function;
        }

        public Integer apply(Optional<BeamHelper.BeamProperties> optionalBeamProperties) {
            return this.function.apply(optionalBeamProperties);
        }

        public Mode getNext() {
            return Mode.values()[this.id + 1 >= Mode.values().length ? 0 : this.id + 1];
        }

        public Vec3i getColor(Optional<BeamHelper.BeamProperties> optionalBeamProperties) {
            return this.color.apply(optionalBeamProperties);
        }

        public String getDescriptionId() {
            return "gui.goggles.optical_sensor.mode." + this.m_7912_();
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

