/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.optical_receptor;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.optical_receptor.OpticalReceptorBlock;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IExtensibleEnum;

public class OpticalReceptorBlockEntity
extends GeneratingKineticBlockEntity {
    public final ReceptorType receptorType;
    private Map<Direction, IBeamReceiver.BeamSourceInstance> beamSourceInstanceMap = OpticalReceptorBlockEntity.emptyMap();
    private BeamHelper.BeamProperties initialBeamProperties = null;
    public NonNullList<ItemStack> sensor = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public Map<Direction, Integer> directionMap = new HashMap<Direction, Integer>();
    public Map<Integer, Direction> integerDirectionMap = new HashMap<Integer, Direction>();

    public static OpticalReceptorBlockEntity speed(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new OpticalReceptorBlockEntity(type, pos, state, ReceptorType.SPEED);
    }

    public static OpticalReceptorBlockEntity capacity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new OpticalReceptorBlockEntity(type, pos, state, ReceptorType.CAPACITY);
    }

    public OpticalReceptorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ReceptorType receptorType) {
        super(type, pos, state);
        this.receptorType = receptorType;
    }

    private static Map<Direction, IBeamReceiver.BeamSourceInstance> emptyMap() {
        HashMap<Direction, IBeamReceiver.BeamSourceInstance> map = new HashMap<Direction, IBeamReceiver.BeamSourceInstance>();
        IBeamReceiver.BeamSourceInstance empty = IBeamReceiver.BeamSourceInstance.empty(null);
        for (Direction direction : Direction.values()) {
            map.put(direction, empty);
        }
        return map;
    }

    public boolean addSensor(@Nonnull ItemStack itemStack, @Nonnull Direction direction) {
        boolean f;
        if (this.isVirtual()) {
            return false;
        }
        int i = this.getIndexSensorOf(direction);
        boolean bl = f = i >= 0 && OpticalReceptorBlock.canPlaceSensorAt(direction, this.m_58900_()) && ((ItemStack)this.sensor.get(i)).m_41619_();
        if (f) {
            this.sensor.set(i, (Object)itemStack);
            this.update();
        }
        return f;
    }

    public boolean removeSensor(@Nonnull Direction direction, Optional<Player> player) {
        boolean f;
        if (this.isVirtual()) {
            return false;
        }
        int i = this.getIndexSensorOf(direction);
        boolean bl = f = !((ItemStack)this.sensor.get(i)).m_41619_();
        if (f) {
            player.ifPresentOrElse(p -> p.m_150109_().m_36054_(((ItemStack)this.sensor.get(i)).m_41777_()), () -> {
                if (!this.m_58898_()) {
                    return;
                }
                if (!this.f_58857_.f_46443_) {
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)((ItemStack)this.sensor.get(i)));
                }
            });
            this.sensor.set(i, (Object)ItemStack.f_41583_);
            this.update();
        }
        return f;
    }

    public int getIndexSensorOf(Direction direction) {
        if (this.directionMap.keySet().isEmpty()) {
            this.updateDirectionMap();
        }
        return this.directionMap.get(direction);
    }

    public void tick() {
        super.tick();
        if (this.directionMap.keySet().isEmpty()) {
            this.updateDirectionMap();
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean f = false;
            for (Direction direction : Direction.values()) {
                if (!this.shouldUpdate(direction)) continue;
                f = true;
            }
            if (f) {
                this.update();
            }
        }
    }

    public void updateDirectionMap() {
        int i = 0;
        for (Direction direction : Direction.values()) {
            if (OpticalReceptorBlock.canPlaceSensorAt(direction, this.m_58900_())) {
                this.directionMap.put(direction, i);
                this.integerDirectionMap.put(i, direction);
                ++i;
                continue;
            }
            this.directionMap.put(direction, -1);
            this.integerDirectionMap.put(-1, direction);
        }
    }

    public void update() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.initialBeamProperties = this.getResultantBeamProperties((Direction)this.m_58900_().m_61143_((Property)OpticalReceptorBlock.FACING));
        this.updateGeneratedRotation();
        this.m_6596_();
        this.sendData();
    }

    @Nullable
    public BeamHelper.BeamProperties getResultantBeamProperties(Direction direction) {
        ArrayList beamProperties = new ArrayList();
        this.beamSourceInstanceMap.keySet().stream().map(direction1 -> this.beamSourceInstanceMap.get(direction1)).forEach(beamSourceInstance -> beamSourceInstance.optionalBeamProperties().ifPresent(beamProperties::add));
        if (beamProperties.isEmpty()) {
            return null;
        }
        return BeamHelper.BeamProperties.sum(direction, beamProperties.stream().toList());
    }

    public boolean shouldUpdate(Direction direction) {
        IBeamReceiver.BeamSourceInstance beamSourceInstance = this.beamSourceInstanceMap.get(direction);
        this.beamSourceInstanceMap.put(direction, beamSourceInstance.checkSourceExistenceAndCompatibility((BlockEntity)this));
        this.m_6596_();
        boolean f = !beamSourceInstance.equals(this.beamSourceInstanceMap.get(direction));
        return f;
    }

    public boolean changeState(Direction direction, BlockPos pos, BeamHelper.BeamProperties beamProperties) {
        int i = this.getIndexSensorOf(direction.m_122424_());
        if (i < 0 || i > 3) {
            return false;
        }
        if (((ItemStack)this.sensor.get(i)).m_41619_()) {
            return false;
        }
        if (this.beamSourceInstanceMap.get(direction).optionalBeamProperties().isEmpty()) {
            this.beamSourceInstanceMap.put(direction, new IBeamReceiver.BeamSourceInstance(Optional.of(beamProperties), pos));
            this.update();
            return true;
        }
        return beamProperties.equals(this.beamSourceInstanceMap.get(direction).optionalBeamProperties().orElse(null));
    }

    public OpticalReceptorBlock.OpticalReceptorGearHeaviness getGearHeaviness() {
        return ((OpticalReceptorBlock)this.m_58900_().m_60734_()).heaviness;
    }

    public float getGeneratedSpeed() {
        Float f = this.receptorType.getSpeed(this);
        return f == null ? super.getGeneratedSpeed() : f.floatValue();
    }

    public float calculateAddedStressCapacity() {
        Float f = this.receptorType.getCapacity(this);
        return f == null ? super.calculateAddedStressCapacity() : f.floatValue();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        int i;
        ListTag listTag;
        super.read(compound, clientPacket);
        if (compound.m_128441_("IBeamSourceMap") && (listTag = (ListTag)compound.m_128423_("IBeamSourceMap")) != null) {
            for (i = 0; i < listTag.size(); ++i) {
                this.beamSourceInstanceMap.put(Direction.values()[i], IBeamReceiver.BeamSourceInstance.read((CompoundTag)listTag.get(i)));
            }
        }
        this.initialBeamProperties = this.getResultantBeamProperties((Direction)this.m_58900_().m_61143_((Property)OpticalReceptorBlock.FACING));
        if (!clientPacket) {
            // empty if block
        }
        if (compound.m_128441_("SensorItems")) {
            this.sensor = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            List itemStacks = NBTHelper.readItemList((ListTag)compound.m_128437_("SensorItems", 10));
            for (i = 0; i < this.sensor.size(); ++i) {
                this.sensor.set(i, (Object)((ItemStack)itemStacks.get(i)));
            }
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        ListTag listTag1 = new ListTag();
        Arrays.stream(Direction.values()).forEach(direction -> {
            CompoundTag tag = new CompoundTag();
            this.beamSourceInstanceMap.get(direction).write(tag);
            listTag1.add((Object)tag);
        });
        compound.m_128365_("IBeamSourceMap", (Tag)listTag1);
        compound.m_128365_("SensorItems", (Tag)NBTHelper.writeItemList(this.sensor));
        super.write(compound, clientPacket);
    }

    public static enum ReceptorType implements IExtensibleEnum
    {
        SPEED("speed", be -> Float.valueOf(be.initialBeamProperties != null ? be.initialBeamProperties.getTheoreticalIntensitySpeed() : 0.0f), be -> null),
        CAPACITY("capacity", be -> Float.valueOf(be.initialBeamProperties != null ? 32.0f : 0.0f), be -> {
            if (be.initialBeamProperties != null) {
                return Float.valueOf(Math.abs(be.initialBeamProperties.getTheoreticalIntensitySpeed()) * 8.0f / 32.0f);
            }
            return Float.valueOf(0.0f);
        });

        private final String nameId;
        private final Function<OpticalReceptorBlockEntity, Float> speed;
        private final Function<OpticalReceptorBlockEntity, Float> capacity;

        private ReceptorType(String nameId, Function<OpticalReceptorBlockEntity, Float> speed, Function<OpticalReceptorBlockEntity, Float> capacity) {
            this.nameId = nameId;
            this.speed = speed;
            this.capacity = capacity;
        }

        @Nullable
        public Float getSpeed(OpticalReceptorBlockEntity be) {
            return this.speed.apply(be);
        }

        @Nullable
        public Float getCapacity(OpticalReceptorBlockEntity be) {
            return this.capacity.apply(be);
        }

        public static ReceptorType create(String name, String nameId, Function<OpticalReceptorBlockEntity, Float> speed, Function<OpticalReceptorBlockEntity, Float> capacity) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

