/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.hologram_source;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.lpcamors.optical.COUtils;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.hologram_source.HologramSourceBlock;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.data.COLang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HologramSourceBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation {
    private IBeamReceiver.BeamSourceInstance beamSourceInstance = IBeamReceiver.BeamSourceInstance.empty(null);
    private HologramSourceProfile profile = new HologramSourceProfile(this.m_58899_());
    private boolean isController = true;

    public HologramSourceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private boolean shouldBeController() {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof HologramSourceBlock)) {
            return false;
        }
        HologramSourceBlock hologramSourceBlock = (HologramSourceBlock)block;
        return HologramSourceBlock.getConnection(state, this.m_58899_(), this.f_58857_, Direction.AxisDirection.NEGATIVE).isEmpty();
    }

    private int calculateConnectionLength() {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof HologramSourceBlock)) {
            return 0;
        }
        HologramSourceBlock hologramSourceBlock = (HologramSourceBlock)block;
        BlockPos pos = this.m_58899_();
        AtomicReference<Integer> l = new AtomicReference<Integer>(0);
        this.onConnection(pos, false, hologramSourceBlockEntity -> l.updateAndGet(v -> v + 1));
        return l.get();
    }

    public void onConnection(BlockPos pos, boolean toConnector, Consumer<Optional<HologramSourceBlockEntity>> consumer) {
        Optional<HologramSourceBlockEntity> be;
        Direction.AxisDirection direction = toConnector ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE;
        BlockPos pos1 = pos;
        do {
            if ((be = HologramSourceBlock.getConnection(this.m_58900_(), pos1, this.f_58857_, direction)).isPresent()) {
                pos1 = be.get().m_58899_();
            }
            consumer.accept(be);
        } while (be.isPresent());
    }

    public boolean isController() {
        return this.isController;
    }

    public void onAdded() {
        if (this.m_58904_() == null || this.m_58904_().f_46443_) {
            return;
        }
        AtomicReference<HologramSourceBlockEntity> newController = new AtomicReference<HologramSourceBlockEntity>(this);
        HologramSourceProfile[] lastProfile = new HologramSourceProfile[]{null};
        List.of(Direction.AxisDirection.POSITIVE, Direction.AxisDirection.NEGATIVE).forEach(axisDirection -> HologramSourceBlock.getConnection(this.m_58900_(), this.m_58899_(), this.m_58904_(), axisDirection).ifPresent(be -> {
            HologramSourceBlockEntity controller = be.getController();
            if (controller == null) {
                return;
            }
            newController.set(controller);
            if (!controller.shouldBeController()) {
                newController.set(controller.findController());
                lastProfile[0] = controller.profile;
            }
        }));
        if (lastProfile[0] != null) {
            newController.get().profile.update(lastProfile[0]);
        }
        newController.get().updateConnection(newController.get());
        this.onConnection(newController.get().m_58899_(), false, opbe -> opbe.ifPresent(be -> be.updateConnection((HologramSourceBlockEntity)((Object)((Object)((Object)newController.get()))))));
    }

    public HologramSourceBlockEntity findController() {
        AtomicReference<HologramSourceBlockEntity> newController = new AtomicReference<HologramSourceBlockEntity>(this);
        this.onConnection(this.m_58899_(), true, b -> b.ifPresent(newController::set));
        return newController.get();
    }

    public void updateConnection(HologramSourceBlockEntity controller) {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            this.isController = controller.m_58899_() == this.m_58899_();
            this.setControllerPos(controller.m_58899_());
            if (this.isController) {
                this.setConnectionLength(this.calculateConnectionLength());
            } else {
                this.profile.update(controller.profile);
            }
            this.sendData();
        }
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_ && this.shouldUpdate()) {
            this.update();
        }
    }

    @Nullable
    public HologramSourceBlockEntity getController() {
        Block block;
        if (this.isController || !((block = this.m_58900_().m_60734_()) instanceof HologramSourceBlock)) {
            return this;
        }
        HologramSourceBlock b = (HologramSourceBlock)block;
        return (HologramSourceBlockEntity)b.getBlockEntity((BlockGetter)this.m_58904_(), this.getControllerPos());
    }

    public AABB getRenderBoundingBox() {
        if (!this.isController) {
            return super.getRenderBoundingBox();
        }
        return this.getProjectionBox().m_82377_(0.0, 1.0, 0.0);
    }

    public AABB getProjectionBox() {
        Vec3 center = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82549_(COUtils.getAbsVec(Vec3.m_82528_((Vec3i)((Direction)this.m_58900_().m_61143_((Property)HologramSourceBlock.f_54117_)).m_122428_().m_122436_())).m_82490_((double)(this.getConnectionLength() - 1) / 2.0));
        center = center.m_82520_(0.0, 0.5 + (double)this.getConnectionLength().intValue() / 2.0, 0.0);
        return new AABB(center, center).m_82400_((double)this.getConnectionLength().intValue() / 2.0);
    }

    public boolean shouldUpdate() {
        IBeamReceiver.BeamSourceInstance beamSourceInstance1 = this.beamSourceInstance;
        this.beamSourceInstance = this.beamSourceInstance.checkSourceExistenceAndCompatibility((BlockEntity)this);
        return !beamSourceInstance1.equals(this.beamSourceInstance);
    }

    public void update() {
        this.m_6596_();
        this.sendData();
    }

    public HologramSourceProfile getProfile() {
        return this.profile;
    }

    public boolean changeState(BlockPos pos, BeamHelper.BeamProperties beamProperties) {
        if (this.beamSourceInstance.optionalBeamProperties().isEmpty()) {
            this.beamSourceInstance = new IBeamReceiver.BeamSourceInstance(Optional.of(beamProperties), pos);
            this.update();
        }
        return beamProperties.equals(this.beamSourceInstance.optionalBeamProperties().orElse(null));
    }

    public Optional<BeamHelper.BeamProperties> getOptionalBeamProperties() {
        return this.beamSourceInstance.optionalBeamProperties();
    }

    public boolean isActive() {
        return this.getOptionalBeamProperties().isPresent();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public Integer getConnectionLength() {
        return this.profile.connectionLength;
    }

    public void setConnectionLength(Integer integer) {
        this.profile.connectionLength = integer;
    }

    public BlockPos getControllerPos() {
        return this.profile.controllerPos;
    }

    public void setControllerPos(BlockPos pos) {
        this.profile.controllerPos = pos;
    }

    public int getFixedAngle() {
        return this.profile.fixedAngle;
    }

    public void setFixedAngle(int fixedAngle) {
        this.profile.fixedAngle = fixedAngle;
    }

    public void setItemStack(ItemStack itemStack) {
        try {
            HologramSourceBlockEntity controller = this.getController();
            controller.profile.stack = itemStack;
            controller.sendData();
            controller.onConnection(controller.m_58899_(), false, opBe -> opBe.ifPresent(be1 -> {
                be1.profile.update(controller.profile);
                be1.sendData();
            }));
        }
        catch (Exception ex) {
            System.out.println("Unable to send data to server in " + ((Object)((Object)this)).toString());
        }
    }

    public ItemStack getItemStack() {
        return this.profile.stack;
    }

    public Mode getMode() {
        return this.profile.displayMode;
    }

    public void setMode(int mode) {
        this.profile.displayMode = Mode.values()[Math.max(0, Math.min(Mode.values().length, mode))];
    }

    public CompoundTag getModeData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("ModeIndex", this.getMode().ordinal());
        tag.m_128405_("Angle", this.getFixedAngle());
        return tag;
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        this.beamSourceInstance = IBeamReceiver.BeamSourceInstance.read(tag);
        HologramSourceProfile.read(tag).ifPresent(hologramSourceProfile -> {
            this.profile.update((HologramSourceProfile)hologramSourceProfile);
            this.isController = hologramSourceProfile.controllerPos.equals((Object)this.m_58899_());
        });
        super.read(tag, clientPacket);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        this.beamSourceInstance.write(tag);
        this.profile.write(tag);
        super.write(tag, clientPacket);
    }

    public boolean hasFixedAngle() {
        return this.profile.displayMode.shouldRenderAngle;
    }

    public static class HologramSourceProfile {
        public BlockPos controllerPos;
        public Integer connectionLength = 1;
        public ItemStack stack = ItemStack.f_41583_;
        public Mode displayMode = Mode.ROTATING_COUNTERCLOCKWISE;
        public Integer fixedAngle = 0;

        public HologramSourceProfile(BlockPos controllerPos) {
            this.controllerPos = controllerPos;
        }

        public HologramSourceProfile update(HologramSourceProfile profile) {
            return this.update(profile.controllerPos, profile.connectionLength, profile.stack, profile.displayMode, profile.fixedAngle);
        }

        public HologramSourceProfile update(BlockPos controllerPos, Integer connectionLength, ItemStack stack, Mode displayMode, Integer fixedAngle) {
            this.controllerPos = controllerPos;
            this.connectionLength = connectionLength;
            this.stack = stack;
            this.displayMode = displayMode;
            this.fixedAngle = fixedAngle;
            return this;
        }

        public void write(CompoundTag tag) {
            ListTag profile = new ListTag();
            ListTag intTags = new ListTag();
            ListTag compoundTags = new ListTag();
            intTags.add((Object)IntTag.m_128679_((int)this.connectionLength));
            compoundTags.add((Object)this.stack.m_41739_(new CompoundTag()));
            CompoundTag tagEnum = new CompoundTag();
            NBTHelper.writeEnum((CompoundTag)tagEnum, (String)"DisplayMode", (Enum)this.displayMode);
            compoundTags.add((Object)tagEnum);
            intTags.add((Object)IntTag.m_128679_((int)this.fixedAngle));
            profile.add((Object)NBTHelper.writeVec3i((Vec3i)this.controllerPos));
            profile.add((Object)intTags);
            profile.add((Object)compoundTags);
            tag.m_128365_("Profile", (Tag)profile);
        }

        public static Optional<HologramSourceProfile> read(CompoundTag tag) {
            HologramSourceProfile profile = null;
            if (tag.m_128441_("Profile")) {
                ListTag profileTag = (ListTag)tag.m_128423_("Profile");
                try {
                    ListTag ints = profileTag.m_128744_(1);
                    ListTag compounds = profileTag.m_128744_(2);
                    profile = new HologramSourceProfile(BlockPos.f_121853_).update(new BlockPos(NBTHelper.readVec3i((ListTag)profileTag.m_128744_(0))), ints.m_128763_(0), ItemStack.m_41712_((CompoundTag)compounds.m_128728_(0)), (Mode)NBTHelper.readEnum((CompoundTag)compounds.m_128728_(1), (String)"DisplayMode", Mode.class), ints.m_128763_(1));
                }
                catch (Exception e) {
                    System.out.println("Unable to load data from tag. ");
                    System.out.println(e.getLocalizedMessage());
                }
            }
            return Optional.ofNullable(profile);
        }
    }

    public static enum Mode {
        ROTATING_COUNTERCLOCKWISE("counterclockwise", false),
        ROTATING_CLOCKWISE("clockwise", false),
        SPECIFIC_ANGLE("specific_angle", true);

        final String translationKey;
        final boolean shouldRenderAngle;

        private Mode(String name, boolean shouldRenderAngle) {
            this.translationKey = "gui.hologram_source.mode_" + name;
            this.shouldRenderAngle = shouldRenderAngle;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public boolean isShouldRenderAngle() {
            return this.shouldRenderAngle;
        }

        public static List<Component> getComponents() {
            ArrayList<Component> components = new ArrayList<Component>();
            for (Mode mode : Mode.values()) {
                components.add((Component)COLang.Prefixes.OPTICAL.translate(mode.getTranslationKey(), new Object[0]));
            }
            return components;
        }
    }
}

