/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks;

import java.util.Optional;
import javax.annotation.Nullable;
import net.lpcamors.optical.blocks.IBeamSource;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.data.COTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IBeamReceiver {
    public static final float BEAM_RADIUS = 0.05f;
    public static final float LIVING_ENTITY_EXTENDED_RADIUS = 3.0f;

    public boolean useCenteredIncidence();

    public void receive(IBeamSource var1, BlockState var2, BlockPos var3, BeamHelper.BeamProperties var4, int var5);

    @Deprecated
    public static Vec3 getLaserIrradiatedFaceOffset(Direction faceIrradiated, BlockPos pos, Level level) {
        AABB[] aabb = new AABB[1];
        IBeamReceiver.getNearLivingEntity(level, pos, 3.0, faceIrradiated).ifPresentOrElse(livingEntity -> {
            boolean f;
            boolean bl = f = level.m_7702_(pos) != null && (level.m_7702_(pos).m_58900_().m_60734_() instanceof IBeamReceiver || level.m_7702_(pos) instanceof IBeamSource);
            if (f) {
                BlockState state = level.m_8055_(pos);
                if (state.m_60734_() instanceof IBeamReceiver || state.m_60795_()) {
                    aabb[0] = new AABB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);
                } else {
                    ChunkAccess bg = level.m_46865_(pos);
                    aabb[0] = state.m_60808_((BlockGetter)bg, pos).m_83215_();
                }
                return;
            }
            AABB aabb1 = livingEntity.m_20191_();
            aabb[0] = aabb1 = aabb1.m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        }, () -> {
            ChunkAccess bg;
            VoxelShape shape;
            IBeamReceiver be;
            Block patt4792$temp;
            BlockState state = level.m_8055_(pos);
            aabb[0] = state.m_60795_() || (patt4792$temp = state.m_60734_()) instanceof IBeamReceiver && (be = (IBeamReceiver)patt4792$temp).useCenteredIncidence() ? new AABB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5) : (!(shape = state.m_60808_((BlockGetter)(bg = level.m_46865_(pos)), pos)).m_83281_() ? shape.m_83215_() : new AABB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5));
        });
        boolean f1 = faceIrradiated.m_122421_().m_122540_() > 0;
        Vec3 vec3 = (!f1 ? new Vec3(aabb[0].f_82291_, aabb[0].f_82292_, aabb[0].f_82293_) : new Vec3(aabb[0].f_82288_, aabb[0].f_82289_, aabb[0].f_82290_)).m_82559_(Vec3.m_82528_((Vec3i)faceIrradiated.m_122436_()));
        return vec3.m_82546_(new Vec3(0.5, 0.5, 0.5).m_82559_(Vec3.m_82528_((Vec3i)faceIrradiated.m_122436_()))).m_82490_(f1 ? 1.0 : -1.0);
    }

    public static Vec3 getLaserIrradiatedFaceOffsetVar(Direction faceIrradiated, BlockPos pos, Level level) {
        ChunkAccess bg;
        VoxelShape shape;
        IBeamReceiver be;
        Block block;
        boolean f;
        AABB[] aabb = new AABB[]{null, null};
        IBeamReceiver.getNearLivingEntity(level, pos, 3.0, faceIrradiated).ifPresent(livingEntity -> {
            AABB aabb1 = livingEntity.m_20191_();
            aabb[0] = aabb1 = aabb1.m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        });
        BlockState state = level.m_8055_(pos);
        boolean bl = f = state.m_60795_() || state.m_204336_(COTags.Blocks.PENETRABLE);
        aabb[1] = f && aabb[0] != null ? null : (f || (block = state.m_60734_()) instanceof IBeamReceiver && (be = (IBeamReceiver)block).useCenteredIncidence() ? new AABB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5) : (!(shape = state.m_60808_((BlockGetter)(bg = level.m_46865_(pos)), pos)).m_83281_() ? shape.m_83215_() : new AABB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5)));
        AABB box = IBeamReceiver.checkBetterBox(aabb[0], aabb[1], faceIrradiated);
        boolean f1 = faceIrradiated.m_122421_().m_122540_() > 0;
        Vec3 vec3 = (!f1 ? new Vec3(box.f_82291_, box.f_82292_, box.f_82293_) : new Vec3(box.f_82288_, box.f_82289_, box.f_82290_)).m_82559_(Vec3.m_82528_((Vec3i)faceIrradiated.m_122436_()));
        return vec3.m_82546_(new Vec3(0.5, 0.5, 0.5).m_82559_(Vec3.m_82528_((Vec3i)faceIrradiated.m_122436_()))).m_82490_(f1 ? 1.0 : -1.0);
    }

    public static AABB checkBetterBox(@Nullable AABB box1, @Nullable AABB box2, Direction direction) {
        if (box1 == null) {
            return box2;
        }
        if (box2 == null) {
            return box1;
        }
        boolean f = direction.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE);
        double d = IBeamReceiver.getMaxMinAABB(box1, f).m_82546_(IBeamReceiver.getMaxMinAABB(box2, f)).m_82507_(direction.m_122434_()) * (double)(f ? 1 : -1);
        return d < 0.0 ? box1 : box2;
    }

    public static Vec3 getMaxMinAABB(AABB box, boolean b) {
        return b ? new Vec3(box.f_82288_, box.f_82289_, box.f_82290_) : new Vec3(box.f_82291_, box.f_82292_, box.f_82293_);
    }

    public static Optional<LivingEntity> getNearLivingEntity(Level level, BlockPos pos, double extendedRadius, Direction direction) {
        AABB aabb = new AABB(pos.m_252807_().m_82549_(new Vec3(extendedRadius, extendedRadius, extendedRadius)), pos.m_252807_().m_82549_(new Vec3(-extendedRadius, -extendedRadius, -extendedRadius)));
        LivingEntity livingEntity = level.m_45963_(LivingEntity.class, TargetingConditions.m_148353_(), null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), aabb);
        if (livingEntity == null) {
            return Optional.empty();
        }
        BlockEntity be = level.m_7702_(pos);
        if (be != null && be.m_58900_().m_60734_() instanceof IBeamReceiver) {
            return Optional.empty();
        }
        return IBeamReceiver.insideOfBounds(pos, direction, livingEntity.m_20191_()) ? Optional.of(livingEntity) : Optional.empty();
    }

    public static boolean insideOfBounds(BlockPos pos, Direction direction, AABB aabb) {
        Vec3 u = Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82490_((double)direction.m_122421_().m_122540_());
        double l = 0.4;
        Vec3 posV = pos.m_252807_();
        AABB aabb1 = new AABB(posV.m_82546_(u.m_82542_(l, l, l)), posV.m_82549_(u.m_82542_(l, l, l)));
        return aabb.m_82381_(aabb1 = aabb1.m_82400_((double)0.05f)) || aabb1.m_82381_(aabb);
    }

    public record BeamSourceInstance(Optional<BeamHelper.BeamProperties> optionalBeamProperties, @Nullable BlockPos pos) {
        public static BeamSourceInstance empty(BlockPos pos) {
            return new BeamSourceInstance(Optional.empty(), pos);
        }

        BeamSourceInstance empty() {
            return BeamSourceInstance.empty(this.pos);
        }

        public static BeamSourceInstance read(CompoundTag tag) {
            int[] arr = tag.m_128441_("SourcePos") ? tag.m_128465_("SourcePos") : null;
            return new BeamSourceInstance(BeamHelper.BeamProperties.read(tag), arr == null ? null : new BlockPos(arr[0], arr[1], arr[2]));
        }

        public void write(CompoundTag tag) {
            if (this.pos != null) {
                tag.m_128385_("SourcePos", new int[]{this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()});
            }
            this.optionalBeamProperties.ifPresent(beamProperties -> beamProperties.write(tag));
        }

        public boolean isPropertiesValid(BeamHelper.BeamProperties beamProperties) {
            return this.optionalBeamProperties.isEmpty() || this.optionalBeamProperties.get().equals(beamProperties);
        }

        public BeamSourceInstance checkSourceExistenceAndCompatibility(BlockEntity be) {
            if (be.m_58898_() && this.pos != null && this.optionalBeamProperties.isPresent()) {
                BlockEntity blockEntity = be.m_58904_().m_7702_(this.pos);
                if (blockEntity instanceof IBeamSource) {
                    IBeamSource iBeamSource = (IBeamSource)blockEntity;
                    if (!iBeamSource.isDependent(be.m_58899_())) {
                        return this.empty();
                    }
                } else {
                    return this.empty();
                }
            }
            return this;
        }
    }
}

