/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.extras.leafculling;

import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;

public class LeafCulling {
    private static final Direction[] VALUES = Direction.values();

    public static boolean isFacingAir(BlockGetter view, BlockPos pos, Direction facing) {
        Vec3i vec = facing.m_122436_();
        return view.m_8055_(pos.m_121955_(vec)).m_60734_() instanceof AirBlock;
    }

    public static boolean surroundedByLeaves(BlockGetter view, BlockPos pos) {
        boolean isAggressiveMode = SodiumClientMod.options().performance.leafCullingQuality == SodiumGameOptions.LeafCullingQuality.SOLID_AGGRESSIVE;
        for (Direction dir : VALUES) {
            BlockPos dirPos;
            BlockState blockstate;
            if (isAggressiveMode && (dir == Direction.DOWN || dir == Direction.UP) || (blockstate = view.m_8055_(dirPos = pos.m_121955_(dir.m_122436_()))).m_60734_() instanceof LeavesBlock || blockstate.m_60804_(view, pos)) continue;
            return false;
        }
        return true;
    }

    public static boolean shouldCullSide(BlockGetter view, BlockPos pos, Direction facing, int depth) {
        if (LeafCulling.isFacingAir(view, pos, facing)) {
            return false;
        }
        Vec3i vec = facing.m_122436_();
        boolean cull = true;
        for (int i = 1; i <= depth; ++i) {
            BlockState state = view.m_8055_(pos.m_121955_(vec.m_142393_(i)));
            cull &= state != null && state.m_60734_() instanceof LeavesBlock;
        }
        return cull;
    }
}

