/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.compat.ccl;

import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.embeddedt.embeddium.api.BlockRendererRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCLCompat {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Xenon-CCL");
    private static Map<Holder<Block>, ICCBlockRenderer> customBlockRenderers;
    private static Map<Holder<Fluid>, ICCBlockRenderer> customFluidRenderers;
    private static List<ICCBlockRenderer> customGlobalRenderers;
    private static final Map<ICCBlockRenderer, BlockRendererRegistry.Renderer> ccRendererToSodium;
    private static final ThreadLocal<PoseStack> STACK_THREAD_LOCAL;

    private static BlockRendererRegistry.Renderer createBridge(ICCBlockRenderer r) {
        return ccRendererToSodium.computeIfAbsent(r, ccRenderer -> (ctx, random, consumer) -> {
            ccRenderer.renderBlock(ctx.state(), ctx.pos(), (BlockAndTintGetter)ctx.world(), STACK_THREAD_LOCAL.get(), consumer, random, ctx.modelData(), ctx.renderLayer());
            return BlockRendererRegistry.RenderResult.OVERRIDE;
        });
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("codechickenlib")) {
            CCLCompat.init();
            BlockRendererRegistry.instance().registerRenderPopulator((resultList, ctx) -> {
                Fluid fluid;
                Block block;
                Holder.Reference holder;
                ICCBlockRenderer renderer;
                if (!customGlobalRenderers.isEmpty()) {
                    for (ICCBlockRenderer r : customGlobalRenderers) {
                        if (!r.canHandleBlock((BlockAndTintGetter)ctx.world(), ctx.pos(), ctx.state(), ctx.renderLayer())) continue;
                        resultList.add(CCLCompat.createBridge(r));
                    }
                }
                if (!customBlockRenderers.isEmpty() && (renderer = customBlockRenderers.get(holder = ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)(block = ctx.state().m_60734_())))) != null && renderer.canHandleBlock((BlockAndTintGetter)ctx.world(), ctx.pos(), ctx.state(), ctx.renderLayer())) {
                    resultList.add(CCLCompat.createBridge(renderer));
                }
                if (!customFluidRenderers.isEmpty() && (renderer = customFluidRenderers.get(holder = ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)(fluid = ctx.state().m_60819_().m_76152_())))) != null && renderer.canHandleBlock((BlockAndTintGetter)ctx.world(), ctx.pos(), ctx.state(), ctx.renderLayer())) {
                    resultList.add(CCLCompat.createBridge(renderer));
                }
            });
        }
    }

    public static void init() {
        try {
            LOGGER.info("Retrieving block renderers");
            Field blockRenderersField = BlockRenderingRegistry.class.getDeclaredField("blockRenderers");
            blockRenderersField.setAccessible(true);
            customBlockRenderers = (Map)blockRenderersField.get(null);
            LOGGER.info("Retrieving fluid renderers");
            Field fluidRenderersField = BlockRenderingRegistry.class.getDeclaredField("fluidRenderers");
            fluidRenderersField.setAccessible(true);
            customFluidRenderers = (Map)fluidRenderersField.get(null);
            LOGGER.info("Retrieving global renderers");
            Field globalRenderersField = BlockRenderingRegistry.class.getDeclaredField("globalRenderers");
            globalRenderersField.setAccessible(true);
            customGlobalRenderers = (List)globalRenderersField.get(null);
            if (customBlockRenderers == null) {
                customBlockRenderers = Collections.emptyMap();
            }
            if (customFluidRenderers == null) {
                customFluidRenderers = Collections.emptyMap();
            }
            if (customGlobalRenderers == null) {
                customGlobalRenderers = Collections.emptyList();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Could not retrieve custom renderers");
        }
    }

    static {
        ccRendererToSodium = new ConcurrentHashMap<ICCBlockRenderer, BlockRendererRegistry.Renderer>();
        STACK_THREAD_LOCAL = ThreadLocal.withInitial(PoseStack::new);
    }
}

