/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.reesesoptions.client.gui.frame.tab;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import me.jellysquid.mods.sodium.client.gui.reesesoptions.client.gui.Dim2iExtended;
import me.jellysquid.mods.sodium.client.gui.reesesoptions.client.gui.FlatButtonWidgetExtended;
import me.jellysquid.mods.sodium.client.gui.reesesoptions.client.gui.frame.AbstractFrame;
import me.jellysquid.mods.sodium.client.gui.reesesoptions.client.gui.frame.components.ScrollBarComponent;
import me.jellysquid.mods.sodium.client.gui.reesesoptions.client.gui.frame.tab.Tab;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.commons.lang3.Validate;

public class TabFrame
extends AbstractFrame {
    private final boolean tabSectionCanScroll;
    private final Dim2i tabSection;
    private final Dim2i frameSection;
    private final List<Tab<?>> tabs = new ArrayList();
    private final Runnable onSetTab;
    private final AtomicReference<Component> tabSectionSelectedTab;
    private ScrollBarComponent tabSectionScrollBar = null;
    private Tab<?> selectedTab;
    private AbstractFrame selectedFrame;

    public TabFrame(Dim2i dim, boolean renderOutline, List<Tab<?>> tabs, Runnable onSetTab, AtomicReference<Component> tabSectionSelectedTab, AtomicReference<Integer> tabSectionScrollBarOffset) {
        super(dim, renderOutline);
        this.tabs.addAll(tabs);
        int tabSectionY = this.tabs.size() * 18;
        this.tabSectionCanScroll = tabSectionY > this.dim.height();
        Optional<Integer> result = tabs.stream().map(tab -> this.getStringWidth((FormattedText)tab.title())).max(Integer::compareTo);
        this.tabSection = new Dim2i(this.dim.x(), this.dim.y(), result.map(integer -> integer + (this.tabSectionCanScroll ? 32 : 24)).orElseGet(() -> (int)((double)this.dim.width() * 0.35)), this.dim.height());
        this.frameSection = new Dim2i(this.tabSection.getLimitX(), this.dim.y(), this.dim.width() - this.tabSection.width(), this.dim.height());
        this.onSetTab = onSetTab;
        if (this.tabSectionCanScroll) {
            this.tabSectionScrollBar = new ScrollBarComponent(new Dim2i(this.tabSection.getLimitX() - 11, this.tabSection.y(), 10, this.tabSection.height()), ScrollBarComponent.Mode.VERTICAL, tabSectionY, this.dim.height(), offset -> {
                tabSectionScrollBarOffset.set((Integer)offset);
                ((Dim2iExtended)this.tabSection).setY(this.dim.y() - this.tabSectionScrollBar.getOffset());
            }, this.dim);
            this.tabSectionScrollBar.setOffset(tabSectionScrollBarOffset.get());
        }
        this.tabSectionSelectedTab = tabSectionSelectedTab;
        if (this.tabSectionSelectedTab.get() != null) {
            this.selectedTab = this.tabs.stream().filter(tab -> tab.getTitle().getString().equals(this.tabSectionSelectedTab.get().getString())).findAny().get();
        }
        this.buildFrame();
        this.tabs.stream().filter(tab -> this.selectedTab != tab).forEach(tab -> tab.getFrameFunction().apply(this.frameSection));
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setTab(Tab<?> tab) {
        this.selectedTab = tab;
        this.tabSectionSelectedTab.set(this.selectedTab.getTitle());
        if (this.onSetTab != null) {
            this.onSetTab.run();
        }
        this.buildFrame();
    }

    @Override
    public void buildFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.selectedTab = this.tabs.get(0);
        }
        this.rebuildTabs();
        this.rebuildTabFrame();
        if (this.tabSectionCanScroll) {
            this.tabSectionScrollBar.updateThumbPosition();
            this.children.add(this.tabSectionScrollBar);
        }
        super.buildFrame();
        this.registerFocusListener(element -> {
            if (element instanceof FlatButtonWidgetExtended) {
                FlatButtonWidgetExtended flatButtonWidget = (FlatButtonWidgetExtended)element;
                if (this.tabSectionCanScroll) {
                    Dim2i dim = flatButtonWidget.getDimensions();
                    int inputOffset = this.tabSectionScrollBar.getOffset();
                    if (dim.y() <= this.dim.y()) {
                        inputOffset += dim.y() - this.dim.y();
                    } else if (dim.getLimitY() >= this.dim.getLimitY()) {
                        inputOffset += dim.getLimitY() - this.dim.getLimitY();
                    }
                    this.tabSectionScrollBar.setOffset(inputOffset);
                }
            }
        });
    }

    private void rebuildTabs() {
        int offsetY = 0;
        for (Tab<?> tab : this.tabs) {
            int x = this.tabSection.x();
            int y = this.tabSection.y();
            int width = this.tabSection.width() - (this.tabSectionCanScroll ? 12 : 4);
            int height = 18;
            Dim2i tabDim = new Dim2i(0, offsetY, width, height);
            ((Dim2iExtended)tabDim).setPoint2i(this.tabSection);
            FlatButtonWidget button = new FlatButtonWidget(tabDim, tab.getTitle(), () -> this.setTab(tab));
            button.setSelected(this.selectedTab == tab);
            button.setLeftAligned(true);
            this.children.add(button);
            offsetY += 18;
        }
    }

    private void rebuildTabFrame() {
        if (this.selectedTab == null) {
            return;
        }
        AbstractFrame frame = (AbstractFrame)this.selectedTab.getFrameFunction().apply(this.frameSection);
        if (frame != null) {
            this.selectedFrame = frame;
            frame.buildFrame();
            this.children.add(frame);
        }
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.applyScissor(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height(), () -> {
            for (AbstractWidget widget : this.children) {
                if (widget == this.selectedFrame) continue;
                widget.m_88315_(drawContext, mouseX, mouseY, delta);
            }
        });
        this.selectedFrame.m_88315_(drawContext, mouseX, mouseY, delta);
        if (this.tabSectionCanScroll) {
            this.tabSectionScrollBar.m_88315_(drawContext, mouseX, mouseY, delta);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.dim.containsCursor(mouseX, mouseY) && super.m_6375_(mouseX, mouseY, button) || this.tabSectionCanScroll && this.tabSectionScrollBar.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY) || this.tabSectionCanScroll && this.tabSectionScrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button) || this.tabSectionCanScroll && this.tabSectionScrollBar.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double verticalAmount) {
        return super.m_6050_(mouseX, mouseY, verticalAmount) || this.tabSectionCanScroll && this.tabSectionScrollBar.m_6050_(mouseX, mouseY, verticalAmount);
    }

    public static class Builder {
        private final List<Tab<?>> functions = new ArrayList();
        private Dim2i dim;
        private boolean renderOutline;
        private Runnable onSetTab;
        private AtomicReference<Component> tabSectionSelectedTab = new AtomicReference<Object>(null);
        private AtomicReference<Integer> tabSectionScrollBarOffset = new AtomicReference<Integer>(0);

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder addTabs(Consumer<List<Tab<?>>> tabs) {
            tabs.accept(this.functions);
            return this;
        }

        public Builder onSetTab(Runnable onSetTab) {
            this.onSetTab = onSetTab;
            return this;
        }

        public Builder setTabSectionSelectedTab(AtomicReference<Component> tabSectionSelectedTab) {
            this.tabSectionSelectedTab = tabSectionSelectedTab;
            return this;
        }

        public Builder setTabSectionScrollBarOffset(AtomicReference<Integer> tabSectionScrollBarOffset) {
            this.tabSectionScrollBarOffset = tabSectionScrollBarOffset;
            return this;
        }

        public TabFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            return new TabFrame(this.dim, this.renderOutline, this.functions, this.onSetTab, this.tabSectionSelectedTab, this.tabSectionScrollBarOffset);
        }
    }
}

