/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.utils;

import dev.kvnmtz.createmobspawners.utils.BoundingBoxUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ParticleUtils {
    public static void drawParticleLine(ParticleOptions particleType, Level level, Vec3 pos1, Vec3 pos2, double space, Vec3 speed) {
        Vec3 direction = pos2.m_82546_(pos1).m_82541_();
        double distance = pos1.m_82554_(pos2);
        Vec3 lastPosition = pos1;
        for (double i = 0.0; i < distance; i += space) {
            Vec3 position = lastPosition.m_82549_(direction.m_82490_(space));
            level.m_7106_(particleType, position.f_82479_, position.f_82480_, position.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
            lastPosition = position;
        }
    }

    public static void drawParticlesWithRandomSpeed(ParticleOptions particleType, Level level, Vec3 position, int amount, double xOffset, double yOffset, double zOffset, double maxSpeed) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < amount; ++i) {
            double x = position.f_82479_ + xOffset * random.m_188583_();
            double y = position.f_82480_ + yOffset * random.m_188583_();
            double z = position.f_82481_ + zOffset * random.m_188583_();
            double speedX = maxSpeed * random.m_188583_();
            double speedY = maxSpeed * random.m_188583_();
            double speedZ = maxSpeed * random.m_188583_();
            level.m_7106_(particleType, x, y, z, speedX, speedY, speedZ);
        }
    }

    public static void drawParticles(ParticleOptions particleType, Level level, Vec3 position, int amount, double xOffset, double yOffset, double zOffset, Vec3 speed) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < amount; ++i) {
            double x = position.f_82479_ + xOffset * random.m_188583_();
            double y = position.f_82480_ + yOffset * random.m_188583_();
            double z = position.f_82481_ + zOffset * random.m_188583_();
            level.m_7106_(particleType, x, y, z, speed.f_82479_, speed.f_82480_, speed.f_82481_);
        }
    }

    public static int getParticleCountForEntity(Entity entity) {
        AABB boundingBox = entity.m_20191_();
        double volume = BoundingBoxUtils.getBoundingBoxVolume(boundingBox);
        return (int)(24.58 * Math.pow(volume, 0.35));
    }

    public static int getParticleCountForBoundingBox(AABB boundingBox) {
        double volume = BoundingBoxUtils.getBoundingBoxVolume(boundingBox);
        return (int)(24.58 * Math.pow(volume, 0.35));
    }

    public static void drawPotionEffectLikeParticles(ParticleOptions particleType, Level level, AABB boundingBox, Vec3 position, Vec3 speed, int amount, float scale) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < amount; ++i) {
            double x = position.f_82479_ + boundingBox.m_82362_() * ((2.0 * random.m_188500_() - 1.0) * (double)scale);
            double y = position.f_82480_ + boundingBox.m_82376_() * random.m_188500_();
            double z = position.f_82481_ + boundingBox.m_82385_() * ((2.0 * random.m_188500_() - 1.0) * (double)scale);
            level.m_7106_(particleType, x, y, z, speed.f_82479_, speed.f_82480_, speed.f_82481_);
        }
    }

    public static void drawPotionEffectParticles(Level level, AABB boundingBox, Vec3 position, int color, int amount) {
        double d0 = (double)(color >> 16 & 0xFF) / 255.0;
        double d1 = (double)(color >> 8 & 0xFF) / 255.0;
        double d2 = (double)(color & 0xFF) / 255.0;
        ParticleUtils.drawPotionEffectLikeParticles((ParticleOptions)ParticleTypes.f_123811_, level, boundingBox, position, new Vec3(d0, d1, d2), amount, 0.5f);
    }
}

