/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.utils;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class DrawStringUtils {
    public static void drawTable(GuiGraphics graphics, int x, int y, int color, boolean dropShadow, int rowCount, int rowSpacing, int columnSpacing, TableColumnDefinition ... columns) {
        Font font = Minecraft.m_91087_().f_91062_;
        int currentX = x;
        int currentY = y;
        for (TableColumnDefinition column : columns) {
            String text;
            int i;
            int maxStringWidth = 0;
            for (i = 0; i < rowCount; ++i) {
                text = column.rowGenerator().apply(i);
                int width = font.m_92895_(text);
                if (width <= maxStringWidth) continue;
                maxStringWidth = width;
            }
            for (i = 0; i < rowCount; ++i) {
                text = column.rowGenerator().apply(i);
                int drawX = switch (column.horizontalAlignment()) {
                    default -> throw new IncompatibleClassChangeError();
                    case TableColumnDefinition.HorizontalAlignment.LEFT -> currentX;
                    case TableColumnDefinition.HorizontalAlignment.RIGHT -> currentX + maxStringWidth - font.m_92895_(text);
                };
                graphics.m_280056_(font, text, drawX, currentY, color, dropShadow);
                Objects.requireNonNull(font);
                currentY += 9 + rowSpacing;
            }
            currentY = y;
            currentX += maxStringWidth + columnSpacing;
        }
    }

    public record TableColumnDefinition(HorizontalAlignment horizontalAlignment, Function<Integer, String> rowGenerator) {

        public static enum HorizontalAlignment {
            LEFT,
            RIGHT;

        }
    }
}

