/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.ponder.scenes;

import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import dev.kvnmtz.createmobspawners.block.custom.entity.MechanicalSpawnerBlockEntity;
import dev.kvnmtz.createmobspawners.capabilities.entitystorage.StoredEntityData;
import dev.kvnmtz.createmobspawners.item.custom.SoulCatcherItem;
import dev.kvnmtz.createmobspawners.item.registry.ModItems;
import dev.kvnmtz.createmobspawners.utils.ParticleUtils;
import java.util.concurrent.atomic.AtomicReference;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class SpawnerScenes {
    public static void spawner(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("spawner", "Mechanical Spawner");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        Vec3i spawnerPos = new Vec3i(2, 1, 2);
        scene.world().showSection(util.select().position(new BlockPos(spawnerPos)), Direction.DOWN);
        scene.idleSeconds(1);
        Vec3 spawnerFaceUp = util.vector().blockSurface(new BlockPos(spawnerPos), Direction.UP);
        Vec3 spawnerCenter = new Vec3(2.5, 1.5, 2.5);
        scene.overlay().showControls(spawnerFaceUp, Pointing.DOWN, 40).rightClick().withItem(((SoulCatcherItem)((Object)ModItems.SOUL_CATCHER.get())).m_7968_());
        scene.idle(7);
        scene.world().modifyBlockEntity(new BlockPos(spawnerPos), MechanicalSpawnerBlockEntity.class, blockEntity -> {
            Level level = blockEntity.m_58904_();
            if (level == null) {
                return;
            }
            Pig pig = (Pig)EntityType.f_20510_.m_20615_(level);
            if (pig == null) {
                return;
            }
            blockEntity.setStoredEntityData(StoredEntityData.of((LivingEntity)pig));
        });
        scene.idle(10);
        scene.overlay().showText(40).attachKeyFrame().placeNearTarget().pointAt(spawnerCenter).text("Right-click the Spawner with a Soul Catcher to place it inside");
        scene.idleSeconds(3);
        scene.rotateCameraY(90.0f);
        scene.idleSeconds(2);
        scene.world().showSection(util.select().fromTo(4, 1, 2, 4, 2, 2), Direction.DOWN);
        scene.idle(10);
        scene.world().showSection(util.select().position(3, 1, 2), Direction.DOWN);
        scene.idleSeconds(2);
        scene.rotateCameraY(-90.0f);
        scene.idleSeconds(1);
        Vec3 upperTankCenter = new Vec3(4.5, 2.5, 2.5);
        scene.overlay().showText(40).attachKeyFrame().placeNearTarget().pointAt(upperTankCenter).text("The Spawner needs a supply of Potion of Regeneration to work");
        scene.idleSeconds(2);
        scene.world().showSection(util.select().position(5, 0, 0), Direction.WEST);
        scene.world().setKineticSpeed(util.select().position(5, 0, 0), -32.0f);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(3, 1, 1, 5, 1, 1), Direction.WEST);
        scene.world().setKineticSpeed(util.select().position(3, 1, 2), -64.0f);
        scene.world().setKineticSpeed(util.select().fromTo(3, 1, 1, 5, 1, 1), 64.0f);
        scene.idleSeconds(1);
        scene.overlay().showText(80).attachKeyFrame().placeNearTarget().pointAt(spawnerFaceUp).text("The Spawner also needs rotational force. The faster the rotation, the faster the spawning progress will finish.");
        scene.idleSeconds(4);
        scene.world().showSection(util.select().position(1, 5, 3), Direction.DOWN);
        scene.world().setKineticSpeed(util.select().position(1, 5, 3), -64.0f);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(2, 2, 2, 2, 5, 2), Direction.DOWN);
        scene.world().setKineticSpeed(util.select().fromTo(2, 1, 2, 2, 5, 2), 128.0f);
        scene.idleSeconds(3);
        AtomicReference<AABB> pigBoundingBox = new AtomicReference<AABB>(AABB.m_165882_((Vec3)Vec3.f_82478_, (double)0.0, (double)0.0, (double)0.0));
        scene.world().createEntity(w -> {
            Pig pig = (Pig)EntityType.f_20510_.m_20615_(w);
            if (pig == null) {
                return null;
            }
            pig.f_19854_ = 1.0;
            pig.f_19855_ = 1.0;
            pig.f_19856_ = 1.0;
            pig.m_20343_(1.0, 1.0, 1.0);
            pig.f_19859_ = 180.0f;
            pig.m_146922_(180.0f);
            pig.f_20886_ = 180.0f;
            pig.m_5616_(180.0f);
            pigBoundingBox.set(pig.m_20191_());
            return pig;
        });
        scene.effects().emitParticles(Vec3.f_82478_, (w, unused1, unused2, unused3) -> {
            AABB bb = (AABB)pigBoundingBox.get();
            ParticleUtils.drawPotionEffectLikeParticles((ParticleOptions)ParticleTypes.f_123771_, (Level)w, bb, new Vec3(1.0, 1.0, 1.0), new Vec3(0.1, 0.1, 0.1), ParticleUtils.getParticleCountForBoundingBox(bb), 0.75f);
        }, 1.0f, 1);
        Vec3 pigPosition = new Vec3(1.0, 1.5, 1.0);
        scene.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(pigPosition).text("Given some time, the Spawner will spawn the applied mob type on a nearby position");
        scene.idleSeconds(3);
        scene.overlay().showControls(spawnerFaceUp, Pointing.DOWN, 40).rightClick().whileSneaking();
        scene.idle(7);
        scene.world().modifyBlockEntity(new BlockPos(spawnerPos), MechanicalSpawnerBlockEntity.class, MechanicalSpawnerBlockEntity::ejectSoulCatcher);
        scene.idle(10);
        scene.overlay().showText(40).attachKeyFrame().placeNearTarget().pointAt(spawnerCenter).text("The Soul Catcher can be ejected by right-clicking the Spawner while sneaking");
        scene.idleSeconds(2);
        scene.markAsFinished();
    }
}

