/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.integration.jei;

import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalTiers;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class EnvironmentalPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return Environmental.location("environmental");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)EnvironmentalItems.SLABFISH_BUCKET.get()), (stack, context) -> stack.m_41783_() != null && stack.m_41783_().m_128425_("SlabfishType", 8) ? stack.m_41783_().m_128461_("SlabfishType") : "");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.ANVIL, EnvironmentalPlugin.getRepairRecipes(registration.getVanillaRecipeFactory()).toList());
    }

    private static Stream<RepairData> getRepairData() {
        return Stream.of(new RepairData(EnvironmentalTiers.EnvironmentalArmorMaterials.YAK.m_6230_(), new ItemStack((ItemLike)EnvironmentalItems.YAK_PANTS.get())));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        return EnvironmentalPlugin.getRepairData().flatMap(repairData -> EnvironmentalPlugin.getRepairRecipes(repairData, vanillaRecipeFactory));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory) {
        Ingredient repairIngredient = repairData.getRepairIngredient();
        List<ItemStack> repairables = repairData.getRepairables();
        List<ItemStack> repairMaterials = List.of(repairIngredient.m_43908_());
        return repairables.stream().mapMulti((itemStack, consumer) -> {
            ItemStack damagedThreeQuarters = itemStack.m_41777_();
            damagedThreeQuarters.m_41721_(damagedThreeQuarters.m_41776_() * 3 / 4);
            ItemStack damagedHalf = itemStack.m_41777_();
            damagedHalf.m_41721_(damagedHalf.m_41776_() / 2);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf));
            consumer.accept(repairWithSame);
            if (!repairMaterials.isEmpty()) {
                ItemStack damagedFully = itemStack.m_41777_();
                damagedFully.m_41721_(damagedFully.m_41776_());
                IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters));
                consumer.accept(repairWithMaterial);
            }
        });
    }

    private static class RepairData {
        private final Ingredient repairIngredient;
        private final List<ItemStack> repairables;

        public RepairData(Ingredient repairIngredient, ItemStack ... repairables) {
            this.repairIngredient = repairIngredient;
            this.repairables = List.of(repairables);
        }

        public Ingredient getRepairIngredient() {
            return this.repairIngredient;
        }

        public List<ItemStack> getRepairables() {
            return this.repairables;
        }
    }
}

