/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.environmental.common.slabfish.SlabfishConditionType;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.teamabnormals.environmental.core.registry.EnvironmentalSlabfishConditions;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.util.ExtraCodecs;

public class SlabfishRenameCondition
implements SlabfishCondition {
    private static final Codec<SlabfishRenameCondition> PATTERN_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Pattern.compile(string));
        }
        catch (PatternSyntaxException var2) {
            return DataResult.error(() -> "Invalid regex pattern '" + string + "': " + var2.getMessage());
        }
    }, Pattern::pattern).fieldOf("pattern").forGetter(SlabfishRenameCondition::getPattern)).apply((Applicative)instance, SlabfishRenameCondition::new));
    private static final Codec<SlabfishRenameCondition> NAMES_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().xmap(list -> (String[])list.toArray(String[]::new), Arrays::asList).fieldOf("names").forGetter(SlabfishRenameCondition::getNames), (App)Codec.BOOL.optionalFieldOf("case_sensitive", (Object)false).forGetter(SlabfishRenameCondition::isCaseSensitive)).apply((Applicative)instance, SlabfishRenameCondition::new));
    public static final Codec<SlabfishRenameCondition> CODEC = ExtraCodecs.m_144639_(NAMES_CODEC, PATTERN_CODEC).xmap(c -> c.left().isPresent() ? (SlabfishRenameCondition)c.left().get() : (SlabfishRenameCondition)c.right().get(), c -> c.getNames() == null ? Either.right((Object)c) : Either.left((Object)c));
    @Nullable
    private final String[] names;
    private final boolean caseSensitive;
    private final Pattern pattern;

    public SlabfishRenameCondition(Pattern pattern) {
        this.names = null;
        this.caseSensitive = false;
        this.pattern = pattern;
    }

    public SlabfishRenameCondition(String[] names, boolean caseSensitive) {
        this.names = names;
        this.caseSensitive = caseSensitive;
        StringBuilder regexBuilder = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            regexBuilder.append("\\b").append(names[i]);
            if (i >= names.length - 1) continue;
            regexBuilder.append("|");
        }
        this.pattern = Pattern.compile(regexBuilder.toString(), (!caseSensitive ? 2 : 0) | 0x40);
    }

    @Nullable
    public String[] getNames() {
        return this.names;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        return context.getEvent() == SlabfishConditionContext.Event.RENAME && this.pattern.matcher(context.getName()).matches();
    }

    @Override
    public SlabfishConditionType getType() {
        return (SlabfishConditionType)EnvironmentalSlabfishConditions.RENAME.get();
    }
}

