/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.environmental.common.slabfish.SlabfishHelper;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalSlabfishTypeTags;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;

public record SlabfishType(Component displayName, ResourceLocation texture, Optional<ResourceLocation> backpack, int priority, SlabfishCondition[] conditions) implements Predicate<SlabfishConditionContext>
{
    public static final Map<TagKey<SlabfishType>, Pair<Float, ChatFormatting>> RARITIES = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(EnvironmentalSlabfishTypeTags.COMMON, Pair.of((Object)Float.valueOf(1.0f), (Object)ChatFormatting.GRAY));
        map.put(EnvironmentalSlabfishTypeTags.UNCOMMON, Pair.of((Object)Float.valueOf(0.6f), (Object)ChatFormatting.GREEN));
        map.put(EnvironmentalSlabfishTypeTags.RARE, Pair.of((Object)Float.valueOf(0.25f), (Object)ChatFormatting.AQUA));
        map.put(EnvironmentalSlabfishTypeTags.EPIC, Pair.of((Object)Float.valueOf(0.05f), (Object)ChatFormatting.LIGHT_PURPLE));
        map.put(EnvironmentalSlabfishTypeTags.LEGENDARY, Pair.of((Object)Float.valueOf(0.01f), (Object)ChatFormatting.GOLD));
    });
    public static final Codec<SlabfishType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252442_.fieldOf("description").forGetter(entry -> entry.displayName), (App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(entry -> entry.texture), (App)ResourceLocation.f_135803_.optionalFieldOf("backpack").forGetter(entry -> entry.backpack), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(entry -> entry.priority), (App)SlabfishCondition.CODEC.listOf().xmap(list -> (SlabfishCondition[])list.toArray(SlabfishCondition[]::new), Arrays::asList).fieldOf("conditions").forGetter(entry -> entry.conditions)).apply((Applicative)instance, SlabfishType::new));
    public static final Codec<SlabfishType> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252442_.fieldOf("description").forGetter(entry -> entry.displayName), (App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(entry -> entry.texture), (App)ResourceLocation.f_135803_.optionalFieldOf("backpack").forGetter(entry -> entry.backpack)).apply((Applicative)instance, (displayName, texture, backpack) -> new SlabfishType((Component)displayName, (ResourceLocation)texture, (Optional<ResourceLocation>)backpack, -1, new SlabfishCondition[0])));

    @Override
    public boolean test(SlabfishConditionContext slabfishEntity) {
        for (SlabfishCondition condition : this.conditions) {
            if (condition.test(slabfishEntity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "SlabfishType{, displayName=" + this.displayName.getString() + ", priority=" + this.priority + "}";
    }

    public Holder<SlabfishType> holder(Level level) {
        Registry<SlabfishType> registry = SlabfishHelper.slabfishTypes(level);
        return registry.m_246971_((ResourceKey)registry.m_7854_((Object)this).get());
    }

    public boolean is(Level level, TagKey<SlabfishType> tag) {
        Registry<SlabfishType> registry = SlabfishHelper.slabfishTypes(level);
        Optional set = registry.m_203431_(tag);
        if (set.isEmpty()) {
            return false;
        }
        return ((HolderSet.Named)set.get()).m_203333_(this.holder(level));
    }

    public boolean canBeSold(Level level) {
        return !this.is(level, EnvironmentalSlabfishTypeTags.NOT_SOLD_BY_WANDERING_TRADER);
    }

    public boolean translucent(Level level) {
        return this.is(level, EnvironmentalSlabfishTypeTags.TRANSLUCENT);
    }

    public static TagKey<SlabfishType> getRandomRarity(float chance) {
        for (Map.Entry<TagKey<SlabfishType>, Pair<Float, ChatFormatting>> entry : RARITIES.entrySet()) {
            if (!(chance <= ((Float)entry.getValue().getFirst()).floatValue())) continue;
            return entry.getKey();
        }
        return EnvironmentalSlabfishTypeTags.COMMON;
    }

    public TagKey<SlabfishType> getRarity(Level level) {
        for (Map.Entry<TagKey<SlabfishType>, Pair<Float, ChatFormatting>> entry : RARITIES.entrySet()) {
            if (!this.is(level, entry.getKey())) continue;
            return entry.getKey();
        }
        return EnvironmentalSlabfishTypeTags.COMMON;
    }

    public boolean isBackpackEmpty(Level level) {
        return this.backpack().isEmpty() || SlabfishHelper.slabfishBackpacks(level).m_7745_(this.backpack().get()) == null;
    }
}

