/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.teamabnormals.environmental.common.slabfish.BackpackType;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import com.teamabnormals.environmental.common.slabfish.SweaterType;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import com.teamabnormals.environmental.core.registry.slabfish.EnvironmentalSlabfishSweaters;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SlabfishHelper {
    public static Registry<SlabfishType> slabfishTypes(Level level) {
        return level.m_9598_().m_175515_(EnvironmentalRegistries.SLABFISH_TYPE);
    }

    public static Registry<SweaterType> slabfishSweaters(Level level) {
        return level.m_9598_().m_175515_(EnvironmentalRegistries.SLABFISH_SWEATER);
    }

    public static Registry<BackpackType> slabfishBackpacks(Level level) {
        return level.m_9598_().m_175515_(EnvironmentalRegistries.SLABFISH_BACKPACK);
    }

    public static Optional<SlabfishType> getSlabfishType(Registry<SlabfishType> registry, SlabfishConditionContext context) {
        return SlabfishHelper.getSlabfishType(registry, __ -> true, context);
    }

    public static Optional<SlabfishType> getSlabfishType(Registry<SlabfishType> registry, Predicate<SlabfishType> predicate, SlabfishConditionContext context) {
        return registry.m_123024_().filter(slabfishType -> predicate.test((SlabfishType)slabfishType) && slabfishType.test(context)).max(Comparator.comparingInt(SlabfishType::priority));
    }

    public static Optional<SweaterType> getSweaterType(Registry<SweaterType> registry, ItemStack stack) {
        return registry.m_123024_().filter(sweaterType -> sweaterType != registry.m_6246_(EnvironmentalSlabfishSweaters.EMPTY) && sweaterType.test(stack)).findFirst();
    }

    public static Optional<BackpackType> getBackpackType(Registry<BackpackType> registry, ItemStack stack) {
        return registry.m_123024_().filter(backpackType -> backpackType.test(stack)).findFirst();
    }

    public static Optional<SlabfishType> getRandomSlabfishType(Registry<SlabfishType> registry, Predicate<SlabfishType> predicate, RandomSource random) {
        return Util.m_214676_(registry.m_123024_().filter(predicate).collect(Collectors.toList()), (RandomSource)random);
    }
}

