/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import com.teamabnormals.environmental.common.block.ColoredWisteriaLeavesBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class WisteriaTreeFeature
extends BlueprintTreeFeature {
    public WisteriaTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int trunkHeight = config.f_68190_.m_226153_(random);
        for (int y = 0; y < trunkHeight; ++y) {
            this.addLog(origin.m_6630_(y));
        }
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.m_122190_((Vec3i)origin.m_6630_(trunkHeight - 2).m_121945_(direction));
        for (int y = 0; y < 3; ++y) {
            this.addLog((BlockPos)pos.m_122190_((Vec3i)pos.m_7494_()));
        }
        ArrayList rootDirections = Lists.newArrayList();
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            if (!WisteriaTreeFeature.m_65788_((LevelSimulatedReader)context.m_159774_(), (BlockPos)origin.m_121945_(direction1).m_7495_()) || trunkHeight <= 2 && direction1 == direction) continue;
            rootDirections.add(direction1);
        }
        if (!rootDirections.isEmpty()) {
            this.addLog(origin.m_121945_((Direction)rootDirections.get(random.m_188503_(rootDirections.size()))));
        }
        pos.m_122190_((Vec3i)pos.m_7495_().m_121945_(Direction.Plane.HORIZONTAL.m_235690_(random)));
        for (int y = 0; y < 3; ++y) {
            this.addLog((BlockPos)pos.m_122190_((Vec3i)pos.m_7494_()));
        }
        Direction direction1 = Direction.Plane.HORIZONTAL.m_235690_(random);
        Direction offset = direction1.m_122427_().m_122424_();
        Set<Direction> directions = Set.of(direction1, direction1.m_122424_(), direction1.m_122427_());
        directions.forEach(branchDirection -> {
            BlockPos.MutableBlockPos branchPos = branchDirection == direction1 ? pos.m_121945_(offset) : pos;
            int height = random.m_188503_(2);
            if (height > 0) {
                this.addLog(pos.m_7494_());
            }
            this.createBranch(branchPos.m_121945_(branchDirection).m_6630_(height), (Direction)branchDirection, random, config);
        });
    }

    private void createBranch(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)pos);
        this.addLog((BlockPos)mutablePos);
        this.addLog((BlockPos)mutablePos.m_122190_((Vec3i)mutablePos.m_121945_(direction)));
        this.addLog((BlockPos)mutablePos.m_122190_((Vec3i)mutablePos.m_121945_(direction).m_7494_()));
        this.createLeaves((BlockPos)mutablePos, direction, random, config);
    }

    private void createLeaves(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                int i = -1 - (random.m_188503_(3) == 0 ? 1 : 0);
                int j = i < -1 && random.m_188503_(2) == 0 ? -1 : 0;
                for (int y = 1; y >= i; --y) {
                    if (y > 0 && x != 0 && z != 0 && random.m_188503_(3) != 0) continue;
                    BlockPos blockpos = pos.m_7918_(x, y, z);
                    if (y > j || y == 0 && x == -direction.m_122429_() && z == -direction.m_122431_()) {
                        this.addSpecialFoliage(blockpos, ((Block)EnvironmentalBlocks.WISTERIA_LEAVES.get()).m_49966_());
                        continue;
                    }
                    if (y == j) {
                        this.addSpecialFoliage(blockpos, (BlockState)config.f_161213_.m_213972_(random, blockpos).m_61124_(ColoredWisteriaLeavesBlock.HALF, (Comparable)Half.TOP));
                        continue;
                    }
                    this.addSpecialFoliage(blockpos, config.f_161213_.m_213972_(random, blockpos));
                }
            }
        }
    }

    public BlockState getSapling() {
        return ((Block)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get()).m_49966_();
    }
}

